package jp.naist.se.stigmata.ui.swing.actions;

/*
 * $Id: AboutAction.java 130 2007-06-13 10:08:01Z tama3 $
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.Utility;

/**
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 130 $ $Date: 2007-06-13 19:08:01 +0900 (Wed, 13 Jun 2007) $
 */
public class AboutAction extends ShowTextAction{
    private static final long serialVersionUID = -7060581883871662749L;

    public AboutAction(Component parent){
        super(parent);
    }

    @Override
    public String getTitle(){
        return Messages.getString("about.dialog.title");
    }

    @Override
    public String getMessage(){
        String aboutMessage = loadStringFromFile(getClass().getResource("/resources/about.txt"));
        
        Package p = getClass().getPackage();
        aboutMessage = aboutMessage.replace("${implementation.version}", p.getImplementationVersion());
        aboutMessage = aboutMessage.replace("${implementation.vendor}",  p.getImplementationVendor());
        aboutMessage = aboutMessage.replace("${implementation.title}",   p.getImplementationTitle());

        return aboutMessage;
    }

    @Override
    public void updatePanel(JPanel panel){
        JLabel logo = new JLabel(Utility.getIcon("stigmata.logo"));
        panel.add(logo, BorderLayout.NORTH);
    }
}
