/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.AbstractOptionsBuilder;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.AvailableOptions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLine;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineDefinitions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Definition;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Group;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IAvailableOptionsChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IDefinitionChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.LongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Option;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortLongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortOption;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelaxerOptionsBuilder
extends AbstractOptionsBuilder {
    private CommandLine commandline;

    public RelaxerOptionsBuilder(InputStream in) {
        super(in);
    }

    @Override
    public Options buildOptions() throws IOException, SAXException, DOMException {
        try {
            this.commandline = new CommandLine(this.getStream());
            Map<String, org.apache.commons.cli.Option> optionMap = this.getOptions(this.commandline.getCommandLineDefinitions());
            Options options = this.buildOptions(optionMap, this.commandline.getAvailableOptions());
            return options;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    @Override
    public String getDefinitionName() {
        if (this.commandline != null) {
            return this.commandline.getName();
        }
        return null;
    }

    private Options buildOptions(Map<String, org.apache.commons.cli.Option> map, AvailableOptions available) {
        Options options = new Options();
        for (IAvailableOptionsChoice choice : available.getContent()) {
            if (choice instanceof Option) {
                Option o = (Option)choice;
                options.addOption(map.get(o.getContent()));
                continue;
            }
            if (!(choice instanceof Group)) continue;
            OptionGroup group = new OptionGroup();
            for (String option : ((Group)choice).getOption()) {
                group.addOption(map.get(option));
            }
            options.addOptionGroup(group);
        }
        return options;
    }

    private Map<String, org.apache.commons.cli.Option> getOptions(CommandLineDefinitions definitions) {
        HashMap<String, org.apache.commons.cli.Option> options = new HashMap<String, org.apache.commons.cli.Option>();
        for (Definition def : definitions.getDefinition()) {
            String name = def.getName();
            IDefinitionChoice choice = def.getContent();
            String shortOption = null;
            String longOption = null;
            if (choice instanceof ShortOption) {
                shortOption = ((ShortOption)choice).getContent();
            } else if (choice instanceof LongOption) {
                longOption = ((LongOption)choice).getContent();
            } else if (choice instanceof ShortLongOption) {
                shortOption = ((ShortLongOption)choice).getShortOption();
                longOption = ((ShortLongOption)choice).getLongOption();
            }
            org.apache.commons.cli.Option option = this.createOption(shortOption, longOption, def);
            options.put(name, option);
        }
        return options;
    }

    private org.apache.commons.cli.Option createOption(String shortOption, String longOption, Definition def) {
        String multipleArgs;
        boolean hasArg = true;
        String argument = def.getArgument();
        int argumentCount = -1;
        if (argument == null || argument.equals("NONE")) {
            hasArg = false;
        }
        if ((multipleArgs = def.getMultipleArgs()) != null && !multipleArgs.trim().equals("")) {
            try {
                argumentCount = Integer.parseInt(multipleArgs);
            }
            catch (NumberFormatException e) {
                argumentCount = -1;
            }
        }
        OptionBuilder builder = null;
        if (longOption != null) {
            builder = OptionBuilder.withLongOpt(longOption);
        }
        if (hasArg) {
            builder = OptionBuilder.hasArg(hasArg);
        }
        if (def.getArgumentName() != null) {
            builder = OptionBuilder.withArgName(def.getArgumentName());
        }
        if (def.getDescription() != null) {
            builder = OptionBuilder.withDescription(this.deleteWhiteSpace(def.getDescription()));
        }
        if (def.getValueSeparator() != null) {
            builder = OptionBuilder.withValueSeparator(def.getValueSeparator().charAt(0));
        }
        if (def.getType() != null) {
            builder = OptionBuilder.withType(def.getType());
        }
        if (def.getRequire() != null) {
            builder = builder.isRequired();
        }
        if (argument != null && argument.equals("OPTIONAL")) {
            builder = builder.hasOptionalArg();
        }
        if (def.getMultipleArgs() != null) {
            builder = argument != null && argument.equals("OPTIONAL") ? (argumentCount > 0 ? OptionBuilder.hasOptionalArgs(argumentCount) : builder.hasOptionalArgs()) : (argumentCount > 0 ? OptionBuilder.hasArgs(argumentCount) : builder.hasArgs());
        }
        if (shortOption != null) {
            return OptionBuilder.create(shortOption);
        }
        return builder.create();
    }

    private String deleteWhiteSpace(String string) {
        BufferedReader in = new BufferedReader(new StringReader(string));
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!first) {
                    result.append(' ');
                }
                if ((line = line.trim()).equals("")) continue;
                result.append(line);
                first = false;
            }
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
        return new String(result);
    }
}

