/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IDefinitionChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.LongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RInterleave;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortLongOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ShortOption;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Definition
implements Serializable,
Cloneable {
    public static final String ARGUMENT_REQUIRED = "REQUIRED";
    public static final String ARGUMENT_OPTIONAL = "OPTIONAL";
    public static final String ARGUMENT_NONE = "NONE";
    private String name_;
    private IDefinitionChoice content_;
    private String description_;
    private String argument_;
    private String argumentName_;
    private String multipleArgs_;
    private String valueSeparator_;
    private String require_;
    private String type_;

    public Definition() {
        this.name_ = "";
    }

    public Definition(Definition source) {
        this.setup(source);
    }

    public Definition(RStack stack) {
        this.setup(stack);
    }

    public Definition(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Definition(Element element) {
        this.setup(element);
    }

    public Definition(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Definition(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Definition(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Definition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Definition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Definition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Definition source) {
        this.name_ = source.name_;
        if (source.content_ != null) {
            this.setContent((IDefinitionChoice)source.getContent().clone());
        }
        this.description_ = source.description_;
        this.argument_ = source.argument_;
        this.argumentName_ = source.argumentName_;
        this.multipleArgs_ = source.multipleArgs_;
        this.valueSeparator_ = source.valueSeparator_;
        this.require_ = source.require_;
        this.type_ = source.type_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        try {
            this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (ShortLongOption.isMatch(stack)) {
            this.setContent(new ShortLongOption(stack));
        } else if (ShortOption.isMatch(stack)) {
            this.setContent(new ShortOption(stack));
        } else if (LongOption.isMatch(stack)) {
            this.setContent(new LongOption(stack));
        }
        RInterleave interleave = new RInterleave(stack);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("argument", "?");
        interleave.addElementSlot("argument-name", "?");
        interleave.addElementSlot("multiple-args", "?");
        interleave.addElementSlot("value-separator", "?");
        interleave.addElementSlot("require", "?");
        interleave.addElementSlot("type", "?");
        if (interleave.isMatch()) {
            try {
                this.description_ = interleave.getElementPropertyAsString("description");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.argument_ = interleave.getElementPropertyAsString("argument");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.argumentName_ = interleave.getElementPropertyAsString("argument-name");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.multipleArgs_ = interleave.getElementPropertyAsString("multiple-args");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.valueSeparator_ = interleave.getElementPropertyAsString("value-separator");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.require_ = interleave.getElementPropertyAsString("require");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                this.type_ = interleave.getElementPropertyAsString("type");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public Object clone() {
        return new Definition(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("definition");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.content_ != null) {
            this.content_.makeElement(element);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.argument_ != null) {
            URelaxer.setElementPropertyByString(element, "argument", this.argument_);
        }
        if (this.argumentName_ != null) {
            URelaxer.setElementPropertyByString(element, "argument-name", this.argumentName_);
        }
        if (this.multipleArgs_ != null) {
            URelaxer.setElementPropertyByString(element, "multiple-args", this.multipleArgs_);
        }
        if (this.valueSeparator_ != null) {
            URelaxer.setElementPropertyByString(element, "value-separator", this.valueSeparator_);
        }
        if (this.require_ != null) {
            URelaxer.setElementPropertyByString(element, "require", this.require_);
        }
        if (this.type_ != null) {
            URelaxer.setElementPropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public IDefinitionChoice getContent() {
        return this.content_;
    }

    public void setContent(IDefinitionChoice content) {
        this.content_ = content;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public String getArgument() {
        return this.argument_;
    }

    public void setArgument(String argument) {
        this.argument_ = argument;
    }

    public String getArgumentName() {
        return this.argumentName_;
    }

    public void setArgumentName(String argumentName) {
        this.argumentName_ = argumentName;
    }

    public String getMultipleArgs() {
        return this.multipleArgs_;
    }

    public void setMultipleArgs(String multipleArgs) {
        this.multipleArgs_ = multipleArgs;
    }

    public String getValueSeparator() {
        return this.valueSeparator_;
    }

    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator_ = valueSeparator;
    }

    public String getRequire() {
        return this.require_;
    }

    public void setRequire(String require) {
        this.require_ = require;
    }

    public String getType() {
        return this.type_;
    }

    public void setType(String type) {
        this.type_ = type;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<definition");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.content_ != null) {
            this.content_.makeTextAttribute(buffer);
        }
        buffer.append(">");
        if (this.content_ != null) {
            this.content_.makeTextElement(buffer);
        }
        if (this.description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.append("</description>");
        }
        if (this.argument_ != null) {
            buffer.append("<argument>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getArgument())));
            buffer.append("</argument>");
        }
        if (this.argumentName_ != null) {
            buffer.append("<argument-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getArgumentName())));
            buffer.append("</argument-name>");
        }
        if (this.multipleArgs_ != null) {
            buffer.append("<multiple-args>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getMultipleArgs())));
            buffer.append("</multiple-args>");
        }
        if (this.valueSeparator_ != null) {
            buffer.append("<value-separator>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getValueSeparator())));
            buffer.append("</value-separator>");
        }
        if (this.require_ != null) {
            buffer.append("<require>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getRequire())));
            buffer.append("</require>");
        }
        if (this.type_ != null) {
            buffer.append("<type>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getType())));
            buffer.append("</type>");
        }
        buffer.append("</definition>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<definition");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.content_ != null) {
            this.content_.makeTextAttribute(buffer);
        }
        buffer.write(">");
        if (this.content_ != null) {
            this.content_.makeTextElement(buffer);
        }
        if (this.description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.write("</description>");
        }
        if (this.argument_ != null) {
            buffer.write("<argument>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getArgument())));
            buffer.write("</argument>");
        }
        if (this.argumentName_ != null) {
            buffer.write("<argument-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getArgumentName())));
            buffer.write("</argument-name>");
        }
        if (this.multipleArgs_ != null) {
            buffer.write("<multiple-args>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getMultipleArgs())));
            buffer.write("</multiple-args>");
        }
        if (this.valueSeparator_ != null) {
            buffer.write("<value-separator>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getValueSeparator())));
            buffer.write("</value-separator>");
        }
        if (this.require_ != null) {
            buffer.write("<require>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getRequire())));
            buffer.write("</require>");
        }
        if (this.type_ != null) {
            buffer.write("<type>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getType())));
            buffer.write("</type>");
        }
        buffer.write("</definition>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<definition");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.content_ != null) {
            this.content_.makeTextAttribute(buffer);
        }
        buffer.print(">");
        if (this.content_ != null) {
            this.content_.makeTextElement(buffer);
        }
        if (this.description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.print("</description>");
        }
        if (this.argument_ != null) {
            buffer.print("<argument>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getArgument())));
            buffer.print("</argument>");
        }
        if (this.argumentName_ != null) {
            buffer.print("<argument-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getArgumentName())));
            buffer.print("</argument-name>");
        }
        if (this.multipleArgs_ != null) {
            buffer.print("<multiple-args>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getMultipleArgs())));
            buffer.print("</multiple-args>");
        }
        if (this.valueSeparator_ != null) {
            buffer.print("<value-separator>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getValueSeparator())));
            buffer.print("</value-separator>");
        }
        if (this.require_ != null) {
            buffer.print("<require>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getRequire())));
            buffer.print("</require>");
        }
        if (this.type_ != null) {
            buffer.print("<type>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getType())));
            buffer.print("</type>");
        }
        buffer.print("</definition>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public String getArgumentAsString() {
        return URelaxer.getString(this.getArgument());
    }

    public String getArgumentNameAsString() {
        return URelaxer.getString(this.getArgumentName());
    }

    public String getMultipleArgsAsString() {
        return URelaxer.getString(this.getMultipleArgs());
    }

    public String getValueSeparatorAsString() {
        return URelaxer.getString(this.getValueSeparator());
    }

    public String getRequireAsString() {
        return URelaxer.getString(this.getRequire());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public void setArgumentByString(String string) {
        this.setArgument(string);
    }

    public void setArgumentNameByString(String string) {
        this.setArgumentName(string);
    }

    public void setMultipleArgsByString(String string) {
        this.setMultipleArgs(string);
    }

    public void setValueSeparatorByString(String string) {
        this.setValueSeparator(string);
    }

    public void setRequireByString(String string) {
        this.setRequire(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "definition")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        if (ShortLongOption.isMatchHungry(target)) {
            $match$ = true;
        } else if (ShortOption.isMatchHungry(target)) {
            $match$ = true;
        } else if (LongOption.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        RInterleave interleave = new RInterleave(target);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("argument", "?");
        interleave.addElementSlot("argument-name", "?");
        interleave.addElementSlot("multiple-args", "?");
        interleave.addElementSlot("value-separator", "?");
        interleave.addElementSlot("require", "?");
        interleave.addElementSlot("type", "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Definition.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Definition.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

