/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.extractors;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.ExtractorNotFoundException;
import jp.naist.se.stigmata.spi.BirthmarkSpi;
import org.apache.commons.beanutils.BeanUtils;

public class BirthmarkExtractorFactory {
    private BirthmarkEnvironment environment;
    private Map<String, BirthmarkExtractor> extractors = new HashMap<String, BirthmarkExtractor>();

    public BirthmarkExtractorFactory(BirthmarkEnvironment env) {
        this.environment = env;
    }

    public BirthmarkExtractor getExtractor(String name) throws ExtractorNotFoundException {
        BirthmarkExtractor extractor = this.extractors.get(name);
        if (extractor == null) {
            extractor = this.buildExtractor(name);
            this.extractors.put(name, extractor);
        }
        return extractor;
    }

    private BirthmarkExtractor buildExtractor(String birthmarkType) throws ExtractorNotFoundException {
        BirthmarkSpi spi = this.environment.getService(birthmarkType);
        BirthmarkExtractor extractor = null;
        if (spi != null) {
            extractor = spi.getExtractor();
            try {
                if (extractor != null) {
                    Map props = BeanUtils.describe((Object)extractor);
                    props.remove("class");
                    props.remove("provider");
                    for (Object keyObject : props.keySet()) {
                        String key = "extractor." + spi.getType() + "." + String.valueOf(keyObject);
                        if (this.environment.getProperty(key) == null) continue;
                        BeanUtils.setProperty((Object)extractor, (String)((String)keyObject), (Object)this.environment.getProperty(key));
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw new InternalError(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (extractor == null) {
            throw new ExtractorNotFoundException("extractor not found: " + birthmarkType);
        }
        return extractor;
    }
}

