/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.result.AbstractComparisonResultSet;
import jp.naist.se.stigmata.result.history.ExtractedBirthmarkServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertainPairComparisonResultSet
extends AbstractComparisonResultSet {
    private int compareCount = -1;
    private Collection<BirthmarkSet> sources = null;

    public CertainPairComparisonResultSet(ExtractionResultSet extraction) {
        super(extraction);
    }

    public CertainPairComparisonResultSet(ExtractionResultSet extraction, Map<String, String> nameMap) {
        super(extraction);
        BirthmarkContext context = extraction.getContext();
        for (Map.Entry<String, String> entry : nameMap.entrySet()) {
            context.addNameMapping(entry.getKey(), entry.getValue());
        }
    }

    public CertainPairComparisonResultSet(ComparisonPair[] pairs, BirthmarkContext context) {
        super(CertainPairComparisonResultSet.createExtractionResultSet(pairs, context));
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, BirthmarkContext context) {
        super(CertainPairComparisonResultSet.createExtractionResultSet(targetX, targetY, context));
    }

    public CertainPairComparisonResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, Map<String, String> mapping, BirthmarkContext context) {
        super(CertainPairComparisonResultSet.createExtractionResultSet(targetX, targetY, context));
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            context.addNameMapping(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int getPairCount() {
        BirthmarkContext context = this.getContext();
        if (this.compareCount < 0) {
            int count = 0;
            count = context.hasNameMapping() ? context.getNameMappingCount() : super.getPairCount();
            this.compareCount = count;
        }
        return this.compareCount;
    }

    @Override
    public Iterator<ComparisonPair> iterator() {
        Iterator<ComparisonPair> iterator = null;
        BirthmarkContext context = this.getContext();
        iterator = context.hasNameMapping() ? new NameMappingIterator(this.extraction) : new NameFindIterator(this.extraction);
        return iterator;
    }

    @Override
    public Iterator<BirthmarkSet> pairSources() {
        if (this.sources == null) {
            this.sources = this.createSources();
        }
        return this.sources.iterator();
    }

    @Override
    public BirthmarkSet[] getPairSources() {
        if (this.sources == null) {
            this.sources = this.createSources();
        }
        return this.sources.toArray(new BirthmarkSet[this.sources.size()]);
    }

    private Collection<BirthmarkSet> createSources() {
        HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
        for (ComparisonPair pair : this) {
            this.addToMap(map, pair.getTarget1());
            this.addToMap(map, pair.getTarget2());
        }
        return map.values();
    }

    private void addToMap(Map<URL, BirthmarkSet> map, BirthmarkSet set) {
        map.put(set.getLocation(), set);
    }

    private static ExtractionResultSet createExtractionResultSet(ComparisonPair[] pairs, BirthmarkContext context) {
        ExtractedBirthmarkServiceManager historyManager = context.getEnvironment().getHistoryManager();
        ExtractionResultSet ers = historyManager.createDefaultResultSet(context);
        ers.setTableType(false);
        try {
            int i = 0;
            while (i < pairs.length) {
                ers.addBirthmarkSet(ExtractionTarget.TARGET_X, pairs[i].getTarget1());
                ers.addBirthmarkSet(ExtractionTarget.TARGET_Y, pairs[i].getTarget2());
                ++i;
            }
        }
        catch (BirthmarkStoreException e) {
            throw new InternalError("never thrown BirthmarkStoreException is thrown");
        }
        return ers;
    }

    private static ExtractionResultSet createExtractionResultSet(BirthmarkSet[] targetX, BirthmarkSet[] targetY, BirthmarkContext context) {
        ExtractionResultSet ers = context.getEnvironment().getHistoryManager().createDefaultResultSet(context);
        ers.setTableType(true);
        try {
            ers.setBirthmarkSets(ExtractionTarget.TARGET_X, targetX);
            ers.setBirthmarkSets(ExtractionTarget.TARGET_Y, targetY);
        }
        catch (BirthmarkStoreException e) {
            throw new InternalError("never thrown BirthmarkStoreException is thrown");
        }
        return ers;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameFindIterator
    implements Iterator<ComparisonPair> {
        private ComparisonPair next;
        private BirthmarkSet setX = null;
        private Iterator<BirthmarkSet> iteratorX;
        private Iterator<BirthmarkSet> iteratorY;
        private ExtractionResultSet extraction;

        public NameFindIterator(ExtractionResultSet extraction) {
            this.extraction = extraction;
            this.iteratorX = extraction.birthmarkSets(ExtractionTarget.TARGET_X);
            this.setX = this.iteratorX.next();
            this.next = this.findNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public ComparisonPair next() {
            ComparisonPair returnValue = this.next;
            this.next = this.findNext();
            return returnValue;
        }

        @Override
        public void remove() {
        }

        private ComparisonPair findNext() {
            ComparisonPair next = null;
            if (this.iteratorY == null || !this.iteratorY.hasNext()) {
                this.iteratorY = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
            }
            if (this.setX != null) {
                while (this.iteratorY.hasNext()) {
                    BirthmarkSet setY = this.iteratorY.next();
                    if (!this.setX.getName().equals(setY.getName())) continue;
                    next = new ComparisonPair(this.setX, setY, this.extraction.getContext());
                    break;
                }
                this.setX = this.iteratorX.hasNext() ? this.iteratorX.next() : null;
                if (next == null) {
                    next = this.findNext();
                }
            }
            return next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameMappingIterator
    implements Iterator<ComparisonPair> {
        private Iterator<Map.Entry<String, String>> names;
        private ComparisonPair nextPair;
        private ExtractionResultSet ers;

        public NameMappingIterator(ExtractionResultSet ers) {
            this.ers = ers;
            this.names = ers.getContext().nameMappingEntries();
            this.nextPair = this.findNextPair();
        }

        @Override
        public ComparisonPair next() {
            ComparisonPair cp = this.nextPair;
            this.nextPair = this.findNextPair();
            return cp;
        }

        @Override
        public boolean hasNext() {
            return this.nextPair != null;
        }

        @Override
        public void remove() {
        }

        private ComparisonPair findNextPair() {
            ComparisonPair pair = null;
            if (this.names.hasNext()) {
                Map.Entry<String, String> entry = this.names.next();
                String n1 = entry.getKey();
                String n2 = entry.getValue();
                BirthmarkSet bs1 = this.ers.getBirthmarkSet(ExtractionTarget.TARGET_X, n1);
                BirthmarkSet bs2 = this.ers.getBirthmarkSet(ExtractionTarget.TARGET_Y, n2);
                pair = bs1 == null || bs2 == null ? this.findNextPair() : new ComparisonPair(bs1, bs2, this.ers.getContext());
            }
            return pair;
        }
    }
}

