/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.printer.ExtractionResultSetPrinter;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.spi.ResultPrinterSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkTree;
import jp.naist.se.stigmata.ui.swing.GUIUtility;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.actions.PopupShowAction;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;
import jp.naist.se.stigmata.utils.AsciiDataWritable;

public class BirthmarkExtractionResultPane
extends JPanel {
    private static final long serialVersionUID = 239084365756236543L;
    private StigmataFrame frame;
    private ExtractionResultSet extraction;

    public BirthmarkExtractionResultPane(StigmataFrame stigmataFrame, ExtractionResultSet ers) {
        this.frame = stigmataFrame;
        this.extraction = ers;
        this.initLayouts();
    }

    private void initLayouts() {
        Box southPanel = Box.createHorizontalBox();
        SaveAction saveAction = new SaveAction(this.frame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                ExtractionResultSetPrinter list = service.getExtractionResultSetPrinter();
                list.printResult(new PrintWriter(out), BirthmarkExtractionResultPane.this.extraction);
            }
        });
        AbstractAction compareAction = new AbstractAction(){
            private static final long serialVersionUID = -1938101718384412339L;

            public void actionPerformed(ActionEvent e) {
                BirthmarkExtractionResultPane.this.frame.compareExtractionResult(BirthmarkExtractionResultPane.this.extraction);
            }
        };
        JButton saveButton = GUIUtility.createButton("savebirthmark", saveAction);
        JButton compareButton = GUIUtility.createButton("comparebirthmark", compareAction);
        JPopupMenu popup = new JPopupMenu();
        popup.add(GUIUtility.createJMenuItem("savebirthmark", saveAction));
        popup.add(GUIUtility.createJMenuItem("comparebirthmark", compareAction));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(new BirthmarkTree(this.extraction.getBirthmarkSets(ExtractionTarget.TARGET_BOTH)));
        this.setLayout(new BorderLayout());
        this.add(popup);
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(saveButton);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(compareButton);
        southPanel.add(Box.createHorizontalGlue());
        this.addMouseListener(new PopupShowAction(popup));
    }
}

