/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkStoreTarget;
import jp.naist.se.stigmata.ComparisonMethod;
import jp.naist.se.stigmata.ExtractionUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BirthmarkContext {
    private BirthmarkEnvironment environment;
    private List<String> birthmarkTypes = new ArrayList<String>();
    private ComparisonMethod method = ComparisonMethod.ROUND_ROBIN_SAME_PAIR;
    private List<String> filterTypes = new ArrayList<String>();
    private Map<String, String> nameMappings = new HashMap<String, String>();
    private ExtractionUnit unit = ExtractionUnit.CLASS;
    private BirthmarkStoreTarget store = BirthmarkStoreTarget.MEMORY;

    public BirthmarkContext(BirthmarkContext context) {
        this.environment = context.getEnvironment();
        this.method = context.getComparisonMethod();
        this.unit = context.getExtractionUnit();
        this.birthmarkTypes = new ArrayList<String>(context.birthmarkTypes);
        this.filterTypes = new ArrayList<String>(context.filterTypes);
        this.nameMappings = new HashMap<String, String>(context.nameMappings);
    }

    public BirthmarkContext(BirthmarkEnvironment environment) {
        this.environment = environment;
    }

    public BirthmarkEnvironment getEnvironment() {
        return this.environment;
    }

    public boolean hasNameMapping() {
        return this.getNameMappingCount() > 0;
    }

    public int getNameMappingCount() {
        return this.nameMappings.size();
    }

    public String getNameMapping(String key) {
        return this.nameMappings.get(key);
    }

    public void addNameMapping(String name1, String name2) {
        this.nameMappings.put(name1, name2);
    }

    public void removeNameMapping(String name1) {
        this.nameMappings.remove(name1);
    }

    public Map<String, String> getNameMappings() {
        return Collections.unmodifiableMap(this.nameMappings);
    }

    public Iterator<Map.Entry<String, String>> nameMappingEntries() {
        return this.getNameMappings().entrySet().iterator();
    }

    public void setNameMappings(Map<String, String> mappings) {
        this.nameMappings.clear();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            this.addNameMapping(entry.getKey(), entry.getValue());
        }
    }

    public void setBirthmarkTypes(String[] types) {
        this.birthmarkTypes.clear();
        int i = 0;
        while (i < types.length) {
            this.addBirthmarkType(types[i]);
            ++i;
        }
    }

    public void addBirthmarkType(String type) {
        if (!this.birthmarkTypes.contains(type)) {
            this.birthmarkTypes.add(type);
        }
    }

    public void removeBirthmarkType(String type) {
        this.birthmarkTypes.remove(type);
    }

    public synchronized String[] getBirthmarkTypes() {
        return this.birthmarkTypes.toArray(new String[this.getBirthmarkTypeSize()]);
    }

    public int getBirthmarkTypeSize() {
        return this.birthmarkTypes.size();
    }

    public ComparisonMethod getComparisonMethod() {
        return this.method;
    }

    public void setComparisonMethod(ComparisonMethod method) {
        this.method = method;
    }

    public ExtractionUnit getExtractionUnit() {
        return this.unit;
    }

    public void setExtractionUnit(ExtractionUnit unit) {
        this.unit = unit;
    }

    public BirthmarkStoreTarget getStoreTarget() {
        return this.store;
    }

    public void setStoreTarget(BirthmarkStoreTarget store) {
        this.store = store;
    }

    public boolean hasFilter() {
        return this.filterTypes.size() > 0;
    }

    public void setFilterTypes(String[] filterTypes) {
        if (filterTypes != null) {
            int i = 0;
            while (i < filterTypes.length) {
                this.addFilterType(filterTypes[i]);
                ++i;
            }
        }
    }

    public void addFilterType(String filterType) {
        if (filterType != null) {
            this.filterTypes.add(filterType);
        }
    }

    public void removeFilterType(String filterType) {
        this.filterTypes.remove(filterType);
    }

    public synchronized String[] getFilterTypes() {
        return this.filterTypes.toArray(new String[this.getFilterTypesCount()]);
    }

    public Iterator<String> filterTypes() {
        return this.filterTypes.iterator();
    }

    public int getFilterTypesCount() {
        return this.filterTypes.size();
    }
}

