/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.birthmarks.cvfv;

import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.AbstractBirthmarkService;
import jp.naist.se.stigmata.birthmarks.comparators.PlainBirthmarkComparator;
import jp.naist.se.stigmata.birthmarks.cvfv.ConstantValueOfFieldVariableBirthmarkExtractor;
import jp.naist.se.stigmata.birthmarks.cvfv.TypeAndValueBirthmarkElement;
import jp.naist.se.stigmata.spi.BirthmarkSpi;

public class ConstantValueOfFieldVariableBirthmarkService
extends AbstractBirthmarkService
implements BirthmarkSpi {
    private BirthmarkComparator comparator = new PlainBirthmarkComparator(this);
    private BirthmarkExtractor extractor = new ConstantValueOfFieldVariableBirthmarkExtractor(this);

    public String getType() {
        return "cvfv";
    }

    public String getDefaultDescription() {
        return "Field type and its initial value.";
    }

    public BirthmarkExtractor getExtractor() {
        return this.extractor;
    }

    public BirthmarkComparator getComparator() {
        return this.comparator;
    }

    public boolean isExpert() {
        return false;
    }

    public boolean isUserDefined() {
        return false;
    }

    public BirthmarkElement buildBirthmarkElement(String value) {
        String signature = value.substring(0, value.indexOf(61));
        String subValue = value.substring(value.indexOf(61) + 1);
        Object elementValue = subValue;
        if (subValue.equals("null")) {
            elementValue = null;
        } else {
            switch (signature.charAt(0)) {
                case 'Z': {
                    if (value.equals("true")) {
                        elementValue = Boolean.TRUE;
                        break;
                    }
                    elementValue = Boolean.FALSE;
                    break;
                }
                case 'C': {
                    elementValue = new Character(subValue.charAt(0));
                    break;
                }
                case 'D': {
                    elementValue = new Double(subValue);
                    break;
                }
                case 'F': {
                    elementValue = new Float(subValue);
                    break;
                }
                case 'S': {
                    elementValue = new Short(subValue);
                    break;
                }
                case 'B': {
                    elementValue = new Byte(subValue);
                    break;
                }
                case 'I': {
                    elementValue = new Integer(subValue);
                    break;
                }
                default: {
                    elementValue = value;
                }
            }
        }
        return new TypeAndValueBirthmarkElement(signature, elementValue);
    }
}

