/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.printer.csv;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.printer.AbstractExtractionResultSetPrinter;

public class ExtractionResultSetCsvPrinter
extends AbstractExtractionResultSetPrinter {
    public void printResult(PrintWriter out, ExtractionResultSet ers) {
        this.printHeader(out);
        Iterator<BirthmarkSet> i = ers.birthmarkSets(ExtractionTarget.TARGET_BOTH);
        while (i.hasNext()) {
            this.printBirthmarkSet(out, i.next());
        }
        this.printFooter(out);
    }

    protected void printBirthmarkSet(PrintWriter out, BirthmarkSet holder) {
        String[] stringArray = holder.getBirthmarkTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            out.print(holder.getName());
            out.print(",");
            out.print(holder.getLocation());
            Birthmark birthmark = holder.getBirthmark(type);
            out.print(",");
            out.print(birthmark.getType());
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.print(",");
                out.print(elements.next());
            }
            out.println();
            ++n2;
        }
    }
}

