/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.printer.xml;

import java.io.PrintWriter;
import java.util.Iterator;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.printer.AbstractExtractionResultSetPrinter;

public class ExtractionResultSetXmlPrinter
extends AbstractExtractionResultSetPrinter {
    public void printResult(PrintWriter out, ExtractionResultSet ers) {
        this.printHeader(out);
        out.printf("    <unit>%s</unit>%n", new Object[]{ers.getExtractionUnit()});
        out.printf("    <birthmark-types>%n", new Object[0]);
        String[] stringArray = ers.getBirthmarkTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            out.printf("      <birthmark-type>%s</birthmark-type>%n", type);
            ++n2;
        }
        out.printf("    </birthmark-types>%n", new Object[0]);
        Iterator<BirthmarkSet> i = ers.birthmarkSets(ExtractionTarget.TARGET_BOTH);
        while (i.hasNext()) {
            this.printBirthmarkSet(out, i.next());
        }
        this.printFooter(out);
    }

    public void printHeader(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<birthmark-result-set>");
        out.println("  <extracted-birthmarks>");
    }

    public void printFooter(PrintWriter out) {
        out.println("  </extracted-birthmarks>");
        out.println("</birthmark-result-set>");
        out.flush();
    }

    public void printBirthmarkSet(PrintWriter out, BirthmarkSet set) {
        out.println("    <extracted-birthmark>");
        out.printf("      <name>%s</name>%n", this.escapeToXmlString(set.getName()));
        out.printf("      <location>%s</location>%n", this.escapeToXmlString(set.getLocation()));
        Iterator<String> i = set.birthmarkTypes();
        while (i.hasNext()) {
            String type = i.next();
            Birthmark birthmark = set.getBirthmark(type);
            out.printf("      <birthmark type=\"%s\" count=\"%d\">%n", birthmark.getType(), birthmark.getElementCount());
            Iterator<BirthmarkElement> elements = birthmark.iterator();
            while (elements.hasNext()) {
                out.printf("        <element>%s</element>%n", this.escapeToXmlString(String.valueOf(elements.next())));
            }
            out.println("      </birthmark>");
        }
        out.println("    </extracted-birthmark>");
    }

    public String escapeToXmlString(Object o) {
        if (o != null) {
            return this.escapeToXmlString(o.toString());
        }
        return null;
    }

    public String escapeToXmlString(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }
}

