/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.result;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.ExtractionResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractComparisonResultSet
implements ComparisonResultSet {
    protected ExtractionResultSet extraction;
    private int count = -1;

    public AbstractComparisonResultSet(ExtractionResultSet extraction) {
        this.extraction = extraction;
    }

    @Override
    public abstract Iterator<ComparisonPair> iterator();

    @Override
    public abstract Iterator<BirthmarkSet> pairSources();

    @Override
    public synchronized BirthmarkSet[] getPairSources() {
        return AbstractComparisonResultSet.getArrays(this.pairSources(), new BirthmarkSet[0]);
    }

    @Override
    public int getPairCount() {
        if (this.count < 0) {
            int calculateCount = 0;
            Iterator<ComparisonPair> i = this.iterator();
            while (i.hasNext()) {
                ++calculateCount;
                i.next();
            }
            this.count = calculateCount;
        }
        return this.count;
    }

    @Override
    public synchronized ComparisonPair[] getPairs() {
        return AbstractComparisonResultSet.getArrays(this.iterator(), new ComparisonPair[0]);
    }

    @Override
    public ComparisonPair getPairAt(int index) {
        int currentIndex = 0;
        for (ComparisonPair pair : this) {
            if (currentIndex == index) {
                return pair;
            }
            ++currentIndex;
        }
        return null;
    }

    @Override
    public BirthmarkContext getContext() {
        return this.extraction.getContext();
    }

    @Override
    public BirthmarkEnvironment getEnvironment() {
        return this.extraction.getEnvironment();
    }

    static synchronized <T> T[] getArrays(Iterator<T> i, T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        while (i.hasNext()) {
            list.add(i.next());
        }
        if (list.size() > array.length) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), list.size());
        }
        int index = 0;
        while (index < list.size()) {
            array[index] = list.get(index);
            ++index;
        }
        return array;
    }
}

