/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.PrintWriter;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.printer.ExtractionResultSetPrinter;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.spi.ResultPrinterSpi;
import jp.naist.se.stigmata.ui.swing.BirthmarkTree;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;
import jp.naist.se.stigmata.utils.AsciiDataWritable;

public class BirthmarkExtractionResultPane
extends JPanel {
    private static final long serialVersionUID = 239084365756236543L;
    private StigmataFrame frame;
    private ExtractionResultSet extraction;

    public BirthmarkExtractionResultPane(StigmataFrame stigmataFrame, ExtractionResultSet ers) {
        this.frame = stigmataFrame;
        this.extraction = ers;
        Box southPanel = Box.createHorizontalBox();
        JButton saveButton = Utility.createButton("savebirthmark", new SaveAction(this.frame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                ExtractionResultSetPrinter list = service.getExtractionResultSetPrinter();
                list.printResult(new PrintWriter(out), BirthmarkExtractionResultPane.this.extraction);
            }
        }));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(new BirthmarkTree(ers.getBirthmarkSets(ExtractionTarget.TARGET_BOTH)));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(saveButton);
        southPanel.add(Box.createHorizontalGlue());
    }
}

