/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import javax.swing.tree.DefaultMutableTreeNode;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkElement;
import jp.naist.se.stigmata.BirthmarkSet;

public class BirthmarkTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -12323457653245L;
    private Birthmark birthmark;

    public BirthmarkTreeNode(Birthmark birthmark) {
        super(String.format("%s (%d)", birthmark.getType(), birthmark.getElementCount()));
        this.setBirthmark(birthmark);
    }

    public BirthmarkTreeNode(BirthmarkSet birthmark) {
        super(String.format("%s (%d)", birthmark.getName(), birthmark.getSumOfElementCount()));
        this.setBirthmark(birthmark);
    }

    public Birthmark getBirthmark() {
        return this.birthmark;
    }

    public void setBirthmark(BirthmarkSet holder) {
        this.addChildBirthmarks(holder, this);
    }

    public void setBirthmark(Birthmark birthmark) {
        this.birthmark = birthmark;
        this.addChildren(birthmark, this);
    }

    private void addChildren(Birthmark birthmark, DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(String.valueOf(birthmark.getType()) + "(" + birthmark.getElementCount() + ")");
        parent.add(node);
        BirthmarkElement[] elements = birthmark.getElements();
        int i = 0;
        while (i < elements.length) {
            node.add(new DefaultMutableTreeNode(elements[i]));
            ++i;
        }
    }

    private void addChildBirthmarks(BirthmarkSet holder, DefaultMutableTreeNode parent) {
        Birthmark[] birthmarks;
        Birthmark[] birthmarkArray = birthmarks = holder.getBirthmarks();
        int n = birthmarks.length;
        int n2 = 0;
        while (n2 < n) {
            Birthmark birthmark = birthmarkArray[n2];
            this.addChildren(birthmark, parent);
            ++n2;
        }
    }
}

