/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.BirthmarkContext;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.ComparisonPair;
import jp.naist.se.stigmata.ComparisonResultSet;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.result.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.spi.ResultPrinterSpi;
import jp.naist.se.stigmata.ui.swing.ClassNameObfuscator;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;
import jp.naist.se.stigmata.ui.swing.actions.UpdateBirthmarkCellColorAction;
import jp.naist.se.stigmata.utils.AsciiDataWritable;

public class PairComparisonResultSetPane
extends JPanel {
    private static final long serialVersionUID = 3298346465652354302L;
    private StigmataFrame frame;
    private ComparisonResultSet comparison;
    private DefaultTableModel model = new PairComparisonResultSetTableModel();
    private JTable table = new JTable(this.model);
    private JLabel averageLabel;
    private JLabel maximumLabel;
    private JLabel minimumLabel;
    private double average;
    private double maximum;
    private double minimum;

    public PairComparisonResultSetPane(StigmataFrame frame, ComparisonResultSet resultset) {
        this.frame = frame;
        this.comparison = resultset;
        this.initComponent();
        this.initData(this.model, resultset);
    }

    private void obfuscateClassNames() {
        ClassNameObfuscator obfuscator = new ClassNameObfuscator();
        ArrayList<ComparisonPair> newList = new ArrayList<ComparisonPair>();
        BirthmarkContext context = this.comparison.getContext();
        for (ComparisonPair pair : this.comparison) {
            BirthmarkSet set1 = obfuscator.obfuscateClassName(pair.getTarget1());
            BirthmarkSet set2 = obfuscator.obfuscateClassName(pair.getTarget2());
            context = this.comparison.getContext();
            newList.add(new ComparisonPair(set1, set2, context));
        }
        try {
            File file = this.frame.getSaveFile(Messages.getStringArray("obfuscationmapping.extension"), Messages.getString("obfuscationmapping.description"));
            if (file == null) {
                return;
            }
            obfuscator.outputNameMappings(file);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("error.dialog.title"), 0);
            return;
        }
        PairComparisonResultSetTableModel newModel = new PairComparisonResultSetTableModel();
        this.initData(newModel, new CertainPairComparisonResultSet(newList.toArray(new ComparisonPair[newList.size()]), context));
        this.model = newModel;
        this.table.setModel(newModel);
    }

    private void initData(DefaultTableModel model, ComparisonResultSet comparison) {
        this.maximum = 0.0;
        this.minimum = 1.0;
        this.average = 0.0;
        model.setColumnIdentifiers(Messages.getStringArray("comparepair.table.columns"));
        for (ComparisonPair pair : comparison) {
            double similarity = pair.calculateSimilarity();
            if (similarity > this.maximum) {
                this.maximum = similarity;
            }
            if (similarity < this.minimum) {
                this.minimum = similarity;
            }
            this.average += similarity;
            model.addRow(new Object[]{pair.getTarget1().getName(), pair.getTarget2().getName(), new Double(similarity)});
        }
        this.average /= (double)comparison.getPairCount();
        this.averageLabel.setText(Double.toString(this.average));
        this.maximumLabel.setText(Double.toString(this.maximum));
        this.minimumLabel.setText(Double.toString(this.minimum));
    }

    private void initComponent() {
        Box buttonPanel = Box.createHorizontalBox();
        JPanel similarityPane = new JPanel(new GridLayout(1, 3));
        Box southPanel = Box.createVerticalBox();
        JButton saveButton = Utility.createButton("savecomparison", new SaveAction(this.frame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) throws IOException {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                service.getComparisonResultSetPrinter().printResult(out, PairComparisonResultSetPane.this.comparison);
            }
        }));
        JButton updateColorButton = Utility.createButton("updatecellcolor", new UpdateBirthmarkCellColorAction(this, this.comparison.getEnvironment()));
        JButton obfuscateButton = Utility.createButton("obfuscate");
        JScrollPane scroll = new JScrollPane();
        this.averageLabel = new JLabel(Double.toString(this.average), 4);
        this.maximumLabel = new JLabel(Double.toString(this.maximum), 4);
        this.minimumLabel = new JLabel(Double.toString(this.minimum), 4);
        scroll.setViewportView(this.table);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer(this.comparison.getEnvironment()));
        similarityPane.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        this.averageLabel.setBorder(new TitledBorder(Messages.getString("average.border")));
        this.maximumLabel.setBorder(new TitledBorder(Messages.getString("maximum.border")));
        this.minimumLabel.setBorder(new TitledBorder(Messages.getString("minimum.border")));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)southPanel, "South");
        similarityPane.add(this.averageLabel);
        similarityPane.add(this.maximumLabel);
        similarityPane.add(this.minimumLabel);
        southPanel.add(similarityPane);
        southPanel.add(buttonPanel);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(saveButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(updateColorButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(obfuscateButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = PairComparisonResultSetPane.this.table.rowAtPoint(e.getPoint());
                    int col = PairComparisonResultSetPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < PairComparisonResultSetPane.this.table.getColumnCount() && row >= 0 && row < PairComparisonResultSetPane.this.table.getRowCount()) {
                        ComparisonPair pair = PairComparisonResultSetPane.this.comparison.getPairAt(row);
                        PairComparisonResultSetPane.this.frame.compareDetails(pair.getTarget1(), pair.getTarget2(), PairComparisonResultSetPane.this.comparison.getContext());
                    }
                }
            }
        });
        obfuscateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PairComparisonResultSetPane.this.obfuscateClassNames();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PairComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 93457234571623497L;

        private PairComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 2) {
                return Double.class;
            }
            return String.class;
        }
    }
}

