/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import jp.naist.se.stigmata.Birthmark;
import jp.naist.se.stigmata.BirthmarkComparator;
import jp.naist.se.stigmata.BirthmarkEnvironment;
import jp.naist.se.stigmata.BirthmarkSet;
import jp.naist.se.stigmata.BirthmarkStoreException;
import jp.naist.se.stigmata.ExtractionResultSet;
import jp.naist.se.stigmata.ExtractionTarget;
import jp.naist.se.stigmata.filter.FilteredComparisonResultSet;
import jp.naist.se.stigmata.printer.PrinterManager;
import jp.naist.se.stigmata.result.CertainPairComparisonResultSet;
import jp.naist.se.stigmata.result.MemoryExtractionResultSet;
import jp.naist.se.stigmata.result.RoundRobinComparisonResultSet;
import jp.naist.se.stigmata.spi.ResultPrinterSpi;
import jp.naist.se.stigmata.ui.swing.ClassNameObfuscator;
import jp.naist.se.stigmata.ui.swing.CompareTableCellRenderer;
import jp.naist.se.stigmata.ui.swing.FilterSelectionPane;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.PopupButton;
import jp.naist.se.stigmata.ui.swing.StigmataFrame;
import jp.naist.se.stigmata.ui.swing.Utility;
import jp.naist.se.stigmata.ui.swing.actions.SaveAction;
import jp.naist.se.stigmata.ui.swing.actions.UpdateBirthmarkCellColorAction;
import jp.naist.se.stigmata.utils.AsciiDataWritable;

public class RoundRobinComparisonResultPane
extends JPanel {
    private static final long serialVersionUID = 2134574576543623L;
    private ExtractionResultSet extraction;
    private JTable table;
    private DefaultTableModel model;
    private JLabel classCount;
    private JLabel comparisonCount;
    private JLabel distinctionRatio;
    private JLabel average;
    private JLabel minimum;
    private JLabel maximum;
    private StigmataFrame stigmataFrame;

    public RoundRobinComparisonResultPane(StigmataFrame stigmata, ExtractionResultSet resultset) {
        this.stigmataFrame = stigmata;
        this.extraction = resultset;
        this.initialize();
        this.compare(this.model);
    }

    @Deprecated
    public RoundRobinComparisonResultPane(StigmataFrame stigmata, BirthmarkEnvironment environment, BirthmarkSet[] birthmarksX, BirthmarkSet[] birthmarksY) {
        this.stigmataFrame = stigmata;
        this.initialize();
        this.compare(this.model);
    }

    private void compare(DefaultTableModel model) {
        int countX = this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_X);
        int countY = this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_Y);
        int comparisonCount = countX * countY;
        this.classCount.setText(Integer.toString(countX + countY));
        this.comparisonCount.setText(Integer.toString(comparisonCount));
        int correct = 0;
        double avg = 0.0;
        double max = 0.0;
        double min = 100.0;
        model.addColumn("");
        Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
        while (i.hasNext()) {
            BirthmarkSet x = i.next();
            model.addColumn(x.getName());
        }
        int sizeX = this.extraction.getBirthmarkSetSize(ExtractionTarget.TARGET_X);
        Iterator<BirthmarkSet> i2 = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
        while (i2.hasNext()) {
            Object[] rows = new Object[sizeX + 1];
            BirthmarkSet setY = i2.next();
            rows[0] = setY.getName();
            int index = 0;
            Iterator<BirthmarkSet> j = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
            while (j.hasNext()) {
                BirthmarkSet setX = j.next();
                double similarity = this.compare(setX, setY, this.extraction.getEnvironment());
                rows[index + 1] = new Double(similarity);
                if (Math.abs(similarity - 1.0) < 1.0E-8) {
                    ++correct;
                }
                avg += similarity;
                if (max < similarity) {
                    max = similarity;
                }
                if (min > similarity) {
                    min = similarity;
                }
                ++index;
            }
            model.addRow(rows);
        }
        this.distinctionRatio.setText(Double.toString((double)(comparisonCount - correct) / (double)comparisonCount));
        this.average.setText(Double.toString(avg /= (double)comparisonCount));
        this.minimum.setText(Double.toString(min));
        this.maximum.setText(Double.toString(max));
    }

    private double compare(BirthmarkSet x, BirthmarkSet y, BirthmarkEnvironment environment) {
        double similarity = 0.0;
        int count = 0;
        String[] stringArray = x.getBirthmarkTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            BirthmarkComparator comparator;
            double result;
            String type = stringArray[n2];
            Birthmark b1 = x.getBirthmark(type);
            Birthmark b2 = y.getBirthmark(type);
            if (b1 != null && b2 != null && !Double.isNaN(result = (comparator = environment.getService(type).getComparator()).compare(b1, b2))) {
                similarity += result;
                ++count;
            }
            ++n2;
        }
        return similarity / (double)count;
    }

    private Component getMainPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.model = new RoundRobinComparisonResultSetTableModel();
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(Double.class, new CompareTableCellRenderer(this.extraction.getEnvironment()));
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = RoundRobinComparisonResultPane.this.table.rowAtPoint(e.getPoint());
                    int col = RoundRobinComparisonResultPane.this.table.columnAtPoint(e.getPoint());
                    if (col >= 1 && col < RoundRobinComparisonResultPane.this.table.getColumnCount() && row >= 0 && row < RoundRobinComparisonResultPane.this.table.getRowCount()) {
                        BirthmarkSet b1 = RoundRobinComparisonResultPane.this.extraction.getBirthmarkSet(ExtractionTarget.TARGET_X, col - 1);
                        BirthmarkSet b2 = RoundRobinComparisonResultPane.this.extraction.getBirthmarkSet(ExtractionTarget.TARGET_Y, row);
                        RoundRobinComparisonResultPane.this.stigmataFrame.compareDetails(b1, b2, RoundRobinComparisonResultPane.this.extraction.getContext());
                    }
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.table.setCellSelectionEnabled(true);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.table);
        scroll.setWheelScrollingEnabled(true);
        panel.add((Component)scroll, "Center");
        Box south = Box.createVerticalBox();
        JPanel box1 = new JPanel(new GridLayout(1, 3));
        this.classCount = new JLabel();
        box1.add(this.classCount);
        this.comparisonCount = new JLabel();
        box1.add(this.comparisonCount);
        this.distinctionRatio = new JLabel();
        box1.add(this.distinctionRatio);
        south.add(box1);
        JPanel box2 = new JPanel(new GridLayout(1, 3));
        box2.setBorder(new TitledBorder(Messages.getString("similarity.border")));
        this.average = new JLabel();
        box2.add(this.average);
        this.minimum = new JLabel();
        box2.add(this.minimum);
        this.maximum = new JLabel();
        box2.add(this.maximum);
        south.add(box2);
        this.classCount.setBorder(new TitledBorder(Messages.getString("numberofclasses.border")));
        this.comparisonCount.setBorder(new TitledBorder(Messages.getString("comparisoncount.border")));
        this.distinctionRatio.setBorder(new TitledBorder(Messages.getString("distinctionratio.border")));
        this.average.setBorder(new TitledBorder(Messages.getString("average.border")));
        this.minimum.setBorder(new TitledBorder(Messages.getString("minimum.border")));
        this.maximum.setBorder(new TitledBorder(Messages.getString("maximum.border")));
        panel.add((Component)south, "South");
        return panel;
    }

    private void mdsButtonActionPerformed(ActionEvent e) {
        BirthmarkSet bs;
        HashMap<URL, BirthmarkSet> map = new HashMap<URL, BirthmarkSet>();
        Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
        while (i.hasNext()) {
            bs = i.next();
            map.put(bs.getLocation(), bs);
        }
        i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
        while (i.hasNext()) {
            bs = i.next();
            map.put(bs.getLocation(), bs);
        }
        int index = 0;
        BirthmarkSet[] set = new BirthmarkSet[map.size()];
        for (Map.Entry entry : map.entrySet()) {
            set[index] = (BirthmarkSet)entry.getValue();
            ++index;
        }
        this.stigmataFrame.showMDSGraph(set, this.extraction.getContext());
    }

    private void graphButtonActionPerformed(ActionEvent e) {
        HashMap<Integer, Integer> values = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < this.table.getRowCount()) {
            int j = 1;
            while (j < this.table.getColumnCount()) {
                Double d = (Double)this.table.getValueAt(i, j);
                int similarity = (int)Math.round(d * 100.0);
                Integer dist = (Integer)values.get(new Integer(similarity));
                if (dist == null) {
                    dist = new Integer(0);
                }
                dist = new Integer(dist + 1);
                values.put(new Integer(similarity), dist);
                ++j;
            }
            ++i;
        }
        this.stigmataFrame.showSimilarityDistributionGraph(values);
    }

    private void initialize() {
        JButton save = Utility.createButton("savecomparison", new SaveAction(this.stigmataFrame, new AsciiDataWritable(){

            public void writeAsciiData(PrintWriter out, String format) {
                ResultPrinterSpi service = PrinterManager.getInstance().getService(format);
                if (service == null) {
                    service = PrinterManager.getDefaultFormatService();
                }
                service.getComparisonResultSetPrinter().printResult(out, new RoundRobinComparisonResultSet(RoundRobinComparisonResultPane.this.extraction));
            }
        }));
        JButton graph = Utility.createButton("showgraph");
        JButton obfuscate = Utility.createButton("obfuscate");
        JButton compare = Utility.createButton("guessedpair");
        JButton updateColor = Utility.createButton("updatecellcolor", new UpdateBirthmarkCellColorAction(this, this.extraction.getEnvironment()));
        JMenuItem mdsMenu = Utility.createJMenuItem("mdsmap");
        PopupButton comparePopup = new PopupButton(compare);
        PopupButton graphPopup = new PopupButton(graph);
        Box southPanel = Box.createHorizontalBox();
        this.setLayout(new BorderLayout());
        this.add(this.getMainPane(), "Center");
        this.add((Component)southPanel, "South");
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(save);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(updateColor);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(graphPopup);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(obfuscate);
        southPanel.add(Box.createHorizontalGlue());
        southPanel.add(comparePopup);
        southPanel.add(Box.createHorizontalGlue());
        graph.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.graphButtonActionPerformed(e);
            }
        });
        mdsMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.mdsButtonActionPerformed(e);
            }
        });
        obfuscate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RoundRobinComparisonResultPane.this.obfuscateClassNames();
            }
        });
        ActionListener compareListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String item = e.getActionCommand();
                if (item.equals("guessedpair")) {
                    RoundRobinComparisonResultPane.this.compareGuessedPair();
                } else if (item.equals("specifiedpair")) {
                    RoundRobinComparisonResultPane.this.compareSpecifiedPair();
                } else if (item.equals("roundrobin.filtering")) {
                    RoundRobinComparisonResultPane.this.compareRoundRobinWithFiltering();
                }
            }
        };
        compare.addActionListener(compareListener);
        String[] comparisonMethods = Messages.getStringArray("comparison.methods.inroundrobinresult");
        int i = 1;
        while (i < comparisonMethods.length) {
            JMenuItem item = Utility.createJMenuItem(comparisonMethods[i]);
            comparePopup.addMenuItem(item);
            item.addActionListener(compareListener);
            ++i;
        }
        graphPopup.addMenuItem(mdsMenu);
    }

    private void compareRoundRobinWithFiltering() {
        FilterSelectionPane pane = new FilterSelectionPane(this.extraction.getEnvironment().getFilterManager());
        int returnValue = JOptionPane.showConfirmDialog(this.stigmataFrame, pane, Messages.getString("filterselection.dialog.title"), 2, 3);
        if (returnValue == 0) {
            String[] filterSetList = pane.getSelectedFilters();
            RoundRobinComparisonResultSet rs = new RoundRobinComparisonResultSet(this.extraction);
            FilteredComparisonResultSet filterResultSet = new FilteredComparisonResultSet(rs, this.extraction.getEnvironment().getFilterManager().getFilterSets(filterSetList));
            this.stigmataFrame.showComparisonResultSet(filterResultSet);
        }
    }

    private void compareGuessedPair() {
        CertainPairComparisonResultSet rs = new CertainPairComparisonResultSet(this.extraction);
        this.stigmataFrame.showComparisonResultSet(rs);
    }

    private void compareSpecifiedPair() {
        File file = this.stigmataFrame.getOpenFile(Messages.getStringArray("comparemapping.extension"), Messages.getString("comparemapping.description"));
        if (file != null) {
            Map<String, String> mapping = this.stigmataFrame.constructMapping(file);
            CertainPairComparisonResultSet comparison = new CertainPairComparisonResultSet(this.extraction, mapping);
            this.stigmataFrame.showComparisonResultSet(comparison);
        }
    }

    private void obfuscateClassNames() {
        block6: {
            ClassNameObfuscator obfuscator = new ClassNameObfuscator();
            try {
                File file = this.stigmataFrame.getSaveFile(Messages.getStringArray("obfuscationmapping.extension"), Messages.getString("obfuscationmapping.description"));
                if (file == null) break block6;
                MemoryExtractionResultSet ers = new MemoryExtractionResultSet(this.extraction.getContext(), this.extraction.isTableType());
                try {
                    BirthmarkSet bs;
                    Iterator<BirthmarkSet> i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_X);
                    while (i.hasNext()) {
                        bs = i.next();
                        ers.addBirthmarkSet(ExtractionTarget.TARGET_X, obfuscator.obfuscateClassName(bs));
                    }
                    i = this.extraction.birthmarkSets(ExtractionTarget.TARGET_Y);
                    while (i.hasNext()) {
                        bs = i.next();
                        ers.addBirthmarkSet(ExtractionTarget.TARGET_Y, obfuscator.obfuscateClassName(bs));
                    }
                }
                catch (BirthmarkStoreException birthmarkStoreException) {
                    // empty catch block
                }
                this.extraction = ers;
                obfuscator.outputNameMappings(file);
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), Messages.getString("error.dialog.title"), 0);
                return;
            }
        }
        RoundRobinComparisonResultSetTableModel model = new RoundRobinComparisonResultSetTableModel();
        this.compare(model);
        this.table.setModel(model);
        this.model = model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RoundRobinComparisonResultSetTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 765435324523543242L;

        private RoundRobinComparisonResultSetTableModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 0) {
                return String.class;
            }
            return Double.class;
        }
    }
}

