/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.filter;

import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jp.naist.se.stigmata.ComparisonPairFilter;
import jp.naist.se.stigmata.filter.FilterTarget;
import jp.naist.se.stigmata.filter.TotalElementCountComparisonPairFilter;
import jp.naist.se.stigmata.filter.TotalElementCountComparisonPairFilterService;
import jp.naist.se.stigmata.spi.ComparisonPairFilterSpi;
import jp.naist.se.stigmata.ui.swing.Messages;
import jp.naist.se.stigmata.ui.swing.filter.AbstractComparisonPairFilterComponentService;
import jp.naist.se.stigmata.ui.swing.filter.ComparisonPairFilterPane;

public class TotalElementCountComparisonPairFilterComponentService
extends AbstractComparisonPairFilterComponentService {
    public ComparisonPairFilterPane createComponent(ComparisonPairFilterSpi service) {
        return new Pane(service);
    }

    public String getFilterName() {
        return "totalelementcount";
    }

    public ComparisonPairFilterSpi getComparisonPairFilterService() {
        return new TotalElementCountComparisonPairFilterService();
    }

    private static class Pane
    extends ComparisonPairFilterPane {
        private static final long serialVersionUID = 8912037614500713027L;
        private ComparisonPairFilterSpi service;
        private JComboBox criterionType;
        private JTextField threshold;
        private JComboBox targetType;

        public Pane(ComparisonPairFilterSpi service) {
            this.service = service;
            this.initLayouts();
        }

        public String[] getErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.threshold.getText().trim().equals("")) {
                errors.add(Messages.getString("error.empty.threshold"));
            }
            try {
                int v = Integer.parseInt(this.threshold.getText());
                if (v < 0) {
                    errors.add(Messages.getString("error.negative.value", v));
                }
            }
            catch (NumberFormatException e) {
                errors.add(Messages.getString("error.invalid.format.integer", this.threshold.getText()));
            }
            return errors.toArray(new String[errors.size()]);
        }

        public ComparisonPairFilter getFilter() {
            try {
                TotalElementCountComparisonPairFilter filter = new TotalElementCountComparisonPairFilter(this.service);
                filter.setCriterion(this.getCriterion((String)this.criterionType.getSelectedItem()));
                filter.setThreshold(Integer.parseInt(this.threshold.getText()));
                filter.setTarget(this.getTarget((String)this.targetType.getSelectedItem()));
                return filter;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public void resetComponents() {
            this.threshold.setText("");
            this.criterionType.setSelectedIndex(0);
            this.targetType.setSelectedItem(this.getDisplayTarget(FilterTarget.BOTH_TARGET));
        }

        public void setFilter(ComparisonPairFilter cpf) {
            TotalElementCountComparisonPairFilter filter = (TotalElementCountComparisonPairFilter)cpf;
            this.criterionType.setSelectedItem(this.getDisplayCriterion(filter.getCriterion()));
            this.threshold.setText(String.valueOf(filter.getThreshold()));
            this.targetType.setSelectedItem(this.getDisplayTarget(filter.getTarget()));
        }

        private void initLayouts() {
            JLabel label = new JLabel(Messages.getString("filter.totalelementcount.label"));
            this.threshold = new JTextField();
            this.criterionType = this.createCriteriaBox(TotalElementCountComparisonPairFilter.getValidCriteria());
            this.targetType = this.createTargetBox();
            this.setLayout(new GridLayout(4, 1));
            this.add(label);
            this.add(this.targetType);
            this.add(this.criterionType);
            this.add(this.threshold);
        }
    }
}

