/*
 * Decompiled with CFR 0.152.
 */
package jp.naist.se.stigmata.ui.swing.mds;

import Jama.Matrix;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import jp.naist.se.stigmata.ui.swing.mds.Coordinate;
import jp.naist.se.stigmata.ui.swing.mds.GeometoryType;
import jp.naist.se.stigmata.ui.swing.mds.LabelMap;
import jp.naist.se.stigmata.ui.swing.mds.MDSMethod;
import jp.naist.se.stigmata.ui.swing.mds.PointComponent;
import jp.naist.se.stigmata.ui.swing.mds.mark.DrawerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDSGraphViewer
extends JLayeredPane {
    private static final long serialVersionUID = -9196070059428975126L;
    private static final int POINT_LAYER = DEFAULT_LAYER;
    private static final int LABEL_LAYER = DEFAULT_LAYER;
    private MDSMethod mds;
    private List<Coordinate> plots = new ArrayList<Coordinate>();
    private Color overColor = PointComponent.DEFAULT_OVER_COLOR;
    private Color pointColor = this.getForeground();
    private boolean sameAspect = false;
    private boolean showLabel = false;
    private List<PointComponent> points = new ArrayList<PointComponent>();
    private List<ActionListener> listeners = new ArrayList<ActionListener>();

    public MDSGraphViewer(MDSMethod mds) {
        this(mds, null);
    }

    public MDSGraphViewer(MDSMethod mds, LabelMap labels) {
        this.mds = mds;
        this.setSize(500, 500);
        this.setMinimumSize(this.getSize());
        this.initLayouts(labels);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setSize(int width, int height) {
        if (width < height) {
            height = width;
        } else {
            width = height;
        }
        super.setSize(width, height);
        this.setPreferredSize(this.getSize());
    }

    public Iterator<Coordinate> coordinates() {
        return this.plots.iterator();
    }

    public int getPointCount() {
        return this.plots.size();
    }

    public Coordinate getCoordinate(int index) {
        return this.plots.get(index);
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public void setShowLabel(boolean showLabel) {
        this.showLabel = showLabel;
        this.repaint();
    }

    public boolean isSameAspect() {
        return this.sameAspect;
    }

    public void setSameAspect(boolean sameAspect) {
        this.sameAspect = sameAspect;
        this.repaint();
    }

    public Color getOverColor() {
        return this.overColor;
    }

    public void setOverColor(Color color) {
        this.overColor = color;
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof PointComponent) {
                ((PointComponent)c).setOverColor(color);
            }
            ++i;
        }
    }

    public Color getPointColor() {
        return this.pointColor;
    }

    public void setPointColor(Color color) {
        this.pointColor = color;
        int i = 0;
        while (i < this.getComponentCount()) {
            Component c = this.getComponent(i);
            if (c instanceof PointComponent) {
                ((PointComponent)c).setForeground(color);
            }
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        g.setColor(Color.GRAY);
        g.drawLine(0, 0, d.width - 1, 0);
        g.drawLine(d.width - 1, 0, d.width - 1, d.height - 1);
        g.drawLine(d.width / 2, d.height, d.width / 2, 0);
        g.drawLine(0, 0, 0, d.height - 1);
        g.drawLine(0, d.height - 1, d.width - 1, d.height - 1);
        g.drawLine(0, d.height / 2, d.width, d.height / 2);
        this.updatePointComponents(d);
    }

    protected void fireEvent(PointComponent p) {
        ActionEvent e = new ActionEvent(this, 0, p.getLabel());
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    private void initLayouts(LabelMap labels) {
        double[] x = this.mds.getCoordinate(0);
        double[] y = this.mds.getCoordinate(1);
        double[] z = this.mds.getCoordinate(2);
        double max = 0.0;
        int i = 0;
        while (i < x.length) {
            if (max < Math.abs(x[i])) {
                max = Math.abs(x[i]);
            }
            ++i;
        }
        i = 0;
        while (i < y.length) {
            if (max < Math.abs(y[i])) {
                max = Math.abs(y[i]);
            }
            ++i;
        }
        i = 0;
        while (i < z.length) {
            if (max < Math.abs(z[i])) {
                max = Math.abs(z[i]);
            }
            ++i;
        }
        int w = this.getWidth();
        int h = this.getHeight();
        int ww = w - 20;
        int hh = h - 20;
        DrawerFactory factory = DrawerFactory.getInstance();
        GeometoryType[] types = GeometoryType.values();
        ActionListener clickedListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MDSGraphViewer.this.fireEvent((PointComponent)e.getSource());
            }
        };
        int i2 = 0;
        while (i2 < x.length) {
            double[] xy = new double[]{-x[i2] / max, -y[i2] / max, z[i2] / max};
            double xx = xy[0] * (double)ww / 2.0 + (double)(w / 2);
            double yy = xy[1] * (double)hh / 2.0 + (double)(h / 2);
            String label = String.valueOf(i2);
            if (labels != null && labels.isAvailableLabel(i2)) {
                label = labels.getLabel(i2);
            }
            Coordinate coordinate = new Coordinate(label, xy[0], xy[1], xy[2]);
            if (labels != null && labels.isGroupEnabled()) {
                coordinate.setGroupId(labels.getGroupIdFromElementName(coordinate.getLabel()));
            }
            this.plots.add(coordinate);
            PointComponent p = new PointComponent(label, x[i2], y[i2], factory.create(types[coordinate.getGroupId()]));
            p.addActionListener(clickedListener);
            this.add((Component)p, POINT_LAYER);
            JLabel l = new JLabel(coordinate.getShowName());
            this.add((Component)l, LABEL_LAYER);
            p.setShowLabel(l);
            Dimension size = p.getSize();
            p.setLocation(new Point((int)(xx - size.getWidth() / 2.0), (int)(yy - size.getHeight() / 2.0)));
            this.points.add(p);
            l.setSize(l.getPreferredSize());
            Point pcp = p.getLocation();
            Dimension dsize = l.getSize();
            l.setLocation(new Point(pcp.x - dsize.width / 2, pcp.y - 15));
            l.setVisible(this.isShowLabel());
            ++i2;
        }
    }

    private void updatePointComponents(Dimension d) {
        int index = 0;
        double width = d.getWidth();
        double height = d.getHeight();
        if (this.isSameAspect()) {
            if (width < height) {
                height = width;
            } else {
                width = height;
            }
        }
        for (PointComponent pc : this.points) {
            this.updateLocation(pc, this.plots.get(index), width, height, d);
            JLabel label = pc.getShowLabel();
            Point pcp = pc.getLocation();
            Dimension dsize = label.getSize();
            label.setLocation(new Point(pcp.x - dsize.width / 2, pcp.y - 15));
            label.setVisible(this.isShowLabel());
            ++index;
        }
    }

    private void updateLocation(PointComponent c, Coordinate coordinate, double width, double height, Dimension d) {
        double xx = coordinate.getX() * (width - 20.0) / 2.0 + d.getWidth() / 2.0;
        double yy = coordinate.getY() * (height - 20.0) / 2.0 + d.getHeight() / 2.0;
        Dimension size = c.getSize();
        c.setLocation(new Point((int)(xx - size.getWidth() / 2.0), (int)(yy - size.getHeight() / 2.0)));
    }

    public static void main(String[] args) throws Exception {
        LabelMap labels = new LabelMap(new String[]{"Atlanta", "Chicago", "Denver", "Houston", "Los Angeles", "Miami", "New York", "San Francisco", "Seattle", "Washington D.C."});
        Matrix matrix = new Matrix((double[][])new double[][]{{0.0, 587.0, 1212.0, 701.0, 1936.0, 604.0, 748.0, 2139.0, 2182.0, 543.0}, {587.0, 0.0, 920.0, 940.0, 1745.0, 1188.0, 713.0, 1858.0, 1737.0, 597.0}, {1212.0, 920.0, 0.0, 879.0, 831.0, 1726.0, 1631.0, 949.0, 1021.0, 1494.0}, {701.0, 940.0, 879.0, 0.0, 1374.0, 968.0, 1420.0, 1645.0, 1891.0, 1220.0}, {1936.0, 1745.0, 831.0, 1374.0, 0.0, 2339.0, 2451.0, 347.0, 959.0, 2300.0}, {604.0, 1188.0, 1726.0, 968.0, 2339.0, 0.0, 1092.0, 2592.0, 2734.0, 923.0}, {748.0, 713.0, 1631.0, 1420.0, 2451.0, 1092.0, 0.0, 2571.0, 2408.0, 205.0}, {2139.0, 1858.0, 949.0, 1645.0, 347.0, 2594.0, 2571.0, 0.0, 678.0, 2442.0}, {2182.0, 1737.0, 1021.0, 1891.0, 959.0, 2734.0, 2408.0, 678.0, 0.0, 2329.0}, {543.0, 597.0, 1494.0, 1220.0, 2300.0, 923.0, 205.0, 2442.0, 2329.0, 0.0}});
        MDSMethod mds = new MDSMethod(matrix);
        mds.getCoordinateMatrix().print(8, 4);
        MDSGraphViewer viewer = new MDSGraphViewer(mds, labels);
        viewer.setShowLabel(true);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add((Component)viewer, "Center");
        f.pack();
        f.setVisible(true);
    }
}

