
separate (adagate.drawisland)

procedure drawPalms is
begin

---------- now draw swaying palms/grasses in order from far to near, 
---------- each using 2 textures intersecting in an "X"

	glUseProgram(pidpalm37); --palmTexShadID);
	-- windtree.vs, otex.fs

	glUniform1i(flev37, foglev); --14dec17
	glUniform1i(fcol37, fogclr); --14dec17
	glUniformMatrix4fv(imvp37, 1, GL_FALSE, imvp(1,1)'address);
	glUniform1i(samp37, 0);
	glUniform1i(dark37, darkness);
	glUniform1f(time37, glfloat(currentTime) ); 
	--shader makes them sway

	glUniform3f(ieye37, glfloat(xeye),glfloat(yeye),glfloat(zeye) );

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);


	-- palms & grasses:  current drawing strategy uses
	-- 2 [double-sided] texture planes arranged in an X;  
	-- Now, the 4 X-wings are each drawn far to near,
	-- while also drawing each tree far to near.

	for i in nprng loop

		j:=far2near(i);  -- draw this one now
		pid := j;

		glUniform3f(icen37, 
			glfloat(pxc(j)),glfloat(pyc(j)),glfloat(pzc(j)));
		glUniform3f(irad37, 
			glfloat(pxr(j)),glfloat(pyr(j)),glfloat(pzr(j)));

		glUniform1f( base37, palmbase(j) );

		if( plant(j)=tgrass ) then
			glBindTexture(GL_TEXTURE_2D, tgrass_texid);
		elsif( plant(j)=cgrass ) then
			glBindTexture(GL_TEXTURE_2D, cgrass_texid);
		elsif( plant(j)=bamboo ) then
			glBindTexture(GL_TEXTURE_2D, bamb_texid);
		elsif( plant(j)=fpalm ) then
			glBindTexture(GL_TEXTURE_2D, fpalm_texid); --FatPalm
		elsif( plant(j)=tpalm ) then
			glBindTexture(GL_TEXTURE_2D, tpalm_texid);
		elsif( plant(j)=spalm ) then
			glBindTexture(GL_TEXTURE_2D, palm_texid);
		else
			raise program_error;
		end if;

-----------------------------------------
--    pid = j in [ 1..16] 
-----------------------------------------
-- spalm => j in [ 1.. 2]		 
-- fpalm => j in [ 3.. 3]
-- tpalm => j in [ 4.. 8]		 
-- bamboo=> j in [ 9..11]		
-- grass => j in [12..14]		
-- tgrass=> j in [15..16]		
-----------------------------------------
-- windtree.vs, otex.fs


		glUniform1i(trid37, glint(pid) );
		w3treeobj.Draw( 
			palm, vertbuff,uvbuff,elembuff,
			xeye-pxc(j), zeye-pzc(j)
			);

	end loop; --i


end drawPalms;

