
separate (gameutils)

procedure updateVert is
	dx,dz,dxz, idealVertAng: float;
begin

	if direction>=0 then

		-- adjust vertical look angle more toward avatar
		dx:=xme-xcam;
		dz:=zme-zcam;

		if dx*dx+dz*dz > 0.01 then

			dxz:=fmath.sqrt( dx*dx+dz*dz );
			idealVertAng := fmath.arctan(yme-ycam,dxz);

			vertAng := (1.0-vfrac)*vertAng + vfrac*idealVertAng;
			ycam := (1.0-vfrac)*ycam + vfrac*iycam;

			-- update camera look direction without changing horizontal:
			cxlook := fmath.cos(vertang)*fmath.sin(choriang);
			cylook := fmath.sin(vertang);
			czlook := fmath.cos(vertang)*fmath.cos(choriang);

		end if;

	end if; --dir>=0


exception -- added 8jan18

	when ada.numerics.argument_error =>

		new_line;
		put("updVert:  xme="&float'image(xme));
		put("updVert:  zme="&float'image(zme));
		new_line;

		put("updVert:  xcam="&float'image(xcam));
		put("updVert:  zcam="&float'image(zcam));
		new_line;

		put("updVert:  xme-xcam="&float'image(xme-xcam));
		put("updVert:  zme-zcam="&float'image(zme-zcam));
		new_line;

		raise;

end updateVert;




