--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--



separate (adagate)

procedure getuserinputs is
	yfloor: constant float := -ymax+aheight;
	dt: float;
begin



----------- begin game controller ---------------------------------
	if joystik or gamepad then

		-- axis values in [-32768...+32767]

		-- JS: 2nd Axis parm:  0..2
		-- GC: 2nd Axis parm:  0..3

		-- unresolved question:  how do I prevent spinning @ startup?

		axis_lx := SDL_JoystickGetAxis(jsa, 0);
		axis_ly := SDL_JoystickGetAxis(jsa, 1);
		handle_gc_left(axis_lx,axis_ly);

		if gamepad then -- these handle move forward/backward
			axis_rx := SDL_JoystickGetAxis(jsa, 2);
			axis_ry := SDL_JoystickGetAxis(jsa, 3);
			handle_gc_right(currentTime,axis_rx,axis_ry);
		end if;

		-- now for the buttons:

		-- 1 => pressed,  0 => not pressed
		-- JS: 2nd Btn parm:  0..7
		-- GC: 2nd Btn parm:  0..11

		zeroBtns; -- set btns 0..8 to zero
		if gamepad then
			btn_4 := SDL_JoystickGetButton(jsa,gshtl); -- shootLeft(LtShoulder)
			btn_5 := SDL_JoystickGetButton(jsa,gshtr); -- shootRight(RtShoulder)
			btn_8 := SDL_JoystickGetButton(jsa,gjmp); -- jump
		elsif joystik then
			btn_0 := SDL_JoystickGetButton(jsa,jbak); -- moveBackward(trigger)
			btn_1 := SDL_JoystickGetButton(jsa,jfor); -- moveForward(thumb)
			btn_2 := SDL_JoystickGetButton(jsa,jshtl); -- shootLeft(thumb)
			btn_3 := SDL_JoystickGetButton(jsa,jshtr); -- shootRight(thumb)
			btn_7 := SDL_JoystickGetButton(jsa,jjmp); -- jump
		end if;

		if btn_7>0 or btn_8>0 then
			jumpTime := currentTime;
			pyjump:= yme;
			vyjump:=2.0;
			jumping:=true;
		end if;

		if btn_4>0 or btn_2>0 then 
			shootLeft(currentTime); 
		end if;

		if btn_5>0 or btn_3>0 then 
			shootRight(currentTime); 
		end if;

		if joystik then
			if    btn_0>0 then -- JS.trigger
				moveBackward(currentTime);
			elsif btn_1>0 then -- JS.thumb
				moveForward(currentTime);
			end if;
		end if;

	--end if; --joystik or gamepad
----------- end game controller ---------------------------------

	else -- using neither joystick nor gamepad





		if( level < 5 ) then -- keyboard & mouseBtn handlers


			if
				( key_map( SDL_SCANCODE_UP ) /= 0 )
				or ( key_map( SDL_SCANCODE_W ) /= 0 )
			then 
				moveForward(currentTime);

			elsif
				( key_map( SDL_SCANCODE_DOWN ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_S ) /= 0 )
			then 
				moveBackward(currentTime);
        
			elsif( key_map( SDL_SCANCODE_E )  /= 0 ) then -- was _W
				portalEnabled:=true;

				--normally music stops AFTER shooting both portals
				--but when debugging I like to better hear shots,
				--and it doesn't hurt to stop music here:
				if level=1 then
					snd4ada_hpp.stopLoop(falls);
				elsif level=2 then
					snd4ada_hpp.stopLoop(dark);
				elsif level=3 then
					snd4ada_hpp.stopLoop(gothic);
				elsif level=4 then
					snd4ada_hpp.stopLoop(neptune);
				end if;


			elsif
			(
				( key_map( SDL_SCANCODE_M )  /= 0 )
				or
				( key_map( SDL_SCANCODE_F1 ) /= 0 )
			)
			then
				dt := currentTime - dBtnTime;
				if( dt > 0.8 ) then
					thirdPerson := not thirdPerson;
					dBtnTime:=currentTime;
				end if;

			elsif( key_map( SDL_SCANCODE_X )  /= 0 ) then 
				dt := currentTime - dBtnTime;
				if( dt > 0.8 ) then
					details:=not details;
					dBtnTime:=currentTime;
				end if;

			elsif( key_map( SDL_SCANCODE_L )  /= 0 ) then 
				shootLeft(currentTime);
			elsif( key_map( SDL_SCANCODE_R )  /= 0 ) then 
				shootRight(currentTime); 

			elsif( key_map( SDL_SCANCODE_C )  /= 0 ) then --only for debugging
				showCross:= not showCross; --22jan18

			end if;


			if( key_map( SDL_SCANCODE_SPACE )  /= 0 ) then
						jumpTime := currentTime;
						pyjump:= yme;
						vyjump:=2.0;
						jumping:=true;
			end if;





------------------------------------------------- zoom addendum 19jan18
		if SDL_PollEvent(test_event'access)>0
		and then test_event.typ = SDL_MouseWheel then

				if test_event.wheel.y<0 then --move eye closer by 1%
					camdist := 0.99*camdist;
					if camdist<0.1 then camdist:=0.1; end if;

				else --move eye away by 1%
					camdist := 1.01*camdist;
					if camdist>10.0 then camdist:=10.0; end if;

				end if;

		end if;
------------------------------------------- zoom addendum 19jan18




-----	///////////////////// begin response to mouse buttons

			MouseState:=SDL_GetMouseState(mousex'access,mousey'access);
			state := integer( MouseState );
			ileft := integer( SDL_BUTTON(1) );
			iright:= integer( SDL_BUTTON(3) );
			if    bitmatch(state, ileft)   then 
				shootLeft(currentTime);
			elsif bitmatch(state, iright)  then 
				shootRight(currentTime);
			end if;


		end if; -- level<5





		-- the following rotations work for ALL levels, even level 5

		deltaT := currentTime - oldTimeKb;

		if
			( key_map( SDL_SCANCODE_LEFT ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_A ) /= 0 )
		then

			if thirdperson then
				roty := angrate3*deltaT;
			else
				roty := angrate1*deltaT;
			end if;


			horiang := horiang + roty;
			--slewToAvLook;
			slewToAv; --26jan18
			roty:=0.0;

			if thirdperson then -- vertang represents camera
				xlook := fmath.cos(0.0)*fmath.sin(horiAng);
				zlook := fmath.cos(0.0)*fmath.cos(horiAng);
			else
				xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
				zlook := fmath.cos(vertAng)*fmath.cos(horiAng);
			end if;
			cylook := fmath.sin(vertAng);




		elsif
			( key_map( SDL_SCANCODE_RIGHT ) /= 0 ) 
				or ( key_map( SDL_SCANCODE_D ) /= 0 )
		then

			if thirdperson then
				roty := -angrate3*deltaT;
			else
				roty := -angrate1*deltaT;
			end if;


			horiang := horiang + roty;
			--slewToAvLook;
			slewToAv; --26jan18
			roty:=0.0;

			if thirdperson then -- vertang represents camera
				xlook := fmath.cos(0.0)*fmath.sin(horiAng);
				zlook := fmath.cos(0.0)*fmath.cos(horiAng);
			else
				xlook := fmath.cos(vertAng)*fmath.sin(horiAng);
				zlook := fmath.cos(vertAng)*fmath.cos(horiAng);
			end if;
			cylook := fmath.sin(vertAng);




		end if;


------ begin mouse move -------------------------------------------
		handle_mouse_move(currentTime);
------ end mouse move -------------------------------------------


	end if; -- neither joystick nor gamepad



end getuserinputs;




