#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
out vec4 aPos;
out float dist2obj;

uniform vec3 eyePos; //12apr18
uniform mat4 MVP;


void main(){
	aPos = vec4( vertexPos, 1.0 );
	dist2obj = length(vertexPos - eyePos);

	vec3 pos = vertexPos;
	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

