#version 330 core


in float mynoise; // -eps...+eps
in vec4 aPos;

out vec4 color;

uniform sampler2D myTextureSampler;

uniform float opacity; // 12jan17 addendum

// color assigned to match radial perturbations



void main(){

	// using newest blurgrad.png
	float spread = 4.0; // color spread
	float yval= spread*mynoise;
	float yavg=0.2; // avg color (bigger=>darker blue)
	float tt = clamp(yval+yavg,0.0,1.0);
   vec2 tPos = vec2( 0.5, tt );

	color = texture( myTextureSampler, tPos).rgba;

	if( (opacity>0.1) && (opacity<1.0) ) color.a *= opacity;

}

/*
--
-- Copyright (C) 2018  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--
*/

