#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
uniform mat4 MVP;

uniform vec3 wPos;
uniform vec3 wRad;

const float ybump=3.0;
const float xbump=0.5;
const float zbump=0.5;

void main(){

	vec3 pos = vertexPos;

	float 
		rx=(pos.x-wPos.x), 
		ry=(pos.y-wPos.y), 
		rz=(pos.z-wPos.z);

	float rxz = sqrt( rx*rx+rz*rz );
	float rxy = sqrt( rx*rx+ry*ry );
	float ryz = sqrt( ry*ry+rz*rz );

	//exponential bump on each face:
	pos.y = ry*(1.0+ybump*exp(-rxz*rxz)) + wPos.y;
	pos.x = rx*(1.0+xbump*exp(-ryz*ryz)) + wPos.x;
	pos.z = rz*(1.0+zbump*exp(-rxy*rxy)) + wPos.z;

	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2018  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

