#version 330 core




#ifdef GL_ES
precision mediump float;
#endif
// mods by dist
// Got bored.

uniform float mytime;
uniform vec2 resolution;

vec2 cmul(const vec2 c1, const vec2 c2)
{
	return vec2(
		c1.x * c2.x - c1.y * c2.y,
		c1.x * c2.y + c1.y * c2.x
	);
}

in vec4 aPos;
in vec2 UV;
in vec4 vEyeSpacePos;

out vec4 FragColor;

void main( void )
{
	//vec2 uPos = ( gl_FragCoord.xy / resolution.y );//original
	vec2 uPos =  UV;
	//uPos -= vec2((0.5*resolution.x/resolution.y), 0.5);
	uPos -= vec2((0.3*resolution.x/resolution.y), 0.3);//shift origin
	uPos *= 4.0; //3.0;
		
	vec3 color = vec3(0.0);
	float vertColor = 0.0;
	for( float i = 0.0; i < 3.0; ++i )
	{
		float t = mytime *(0.6) + 1.0;
	
		vec2 origPos = uPos;
		uPos.y += sin( uPos.y/2.0+uPos.x/2.0*(i/0.5+1.0)+t ) * 1.1;
		//uPos.x += sin( uPos.y/2.0+uPos.x/1.0*(i/0.5+1.0)+t ) * 2.1;
		
		uPos =  cmul(origPos, uPos);
		
		float fTemp = abs(9.0 / uPos.y/0.09 / 100.0);
		vertColor += fTemp;
		color += vec3( fTemp*i/5.0, fTemp*i/40.0, pow(fTemp,i/24.0)/64.0 );
		//color += vec3( fTemp*i/4.0, 0.0, 0.0 );
	}
	
	vec4 color_final = vec4(color, 1.0);
	FragColor = color_final;
}
