
separate (adagate.drawisland)



procedure drawfish is
begin

-------- draw fish here begin ----------------------------------------

	-- orbit center:
	fishx:= -7.0;  fishy:= mwaterlevel-0.04;  fishz:= -7.0;

	gluseprogram(pidfish11);
	glUniform1i(arot11, 1 ); --RotSense(1=>CW, -1=>CCW)
	gluniformmatrix4fv(imvp11, 1, gl_false, imvp(1,1)'address );
	gluniform1i(samp11,0);

	-- setup for 2 types of small tropical fish
	glUniform1f(irad11, 1.0 ); --swim circle radius
	glUniform1f(svel11, 1.0 ); --swim speed
	glUniform1f(wvel11, 1.0 ); --wiggle speed
	glUniform1f(wamp11, 1.0 ); --wiggle amplitude
	glUniform3f(icen11, glfloat(fishx),glfloat(fishy),glfloat(fishz) );


	--portal-exterior discard (unused):
	glUniform1i(side11, 0 ); -- -1=>min, +1=>max, 0=>no-discard

	glUniform3f(ieye11, glfloat(xeye),glfloat(yeye),glfloat(zeye));

	glUniform3f(lprt11, glfloat(xtgt1),glfloat(ytgt1),glfloat(ztgt1) ); 
	glUniform3f(rprt11, glfloat(xtgt2),glfloat(ytgt2),glfloat(ztgt2) ); 


	glbindtexture(gl_texture_2d, mfish_texid); -- 3 multi-colored

	glUniform1f(time11, glfloat(currentTime) );
	myfish.draw( mfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+3.0) );
	myfish.draw( mfish, vertbuff,uvbuff,elembuff ); 

	glUniform1f(time11, glfloat(currentTime+9.0) );
	myfish.draw( mfish, vertbuff,uvbuff,elembuff );




	glbindtexture(gl_texture_2d, bfish_texid); -- 2 blue-tropicals
	glUniform3f(icen11, 
		glfloat(fishx+0.4), glfloat(fishy), glfloat(fishz-0.4) );

	glUniform1f(time11, glfloat(currentTime) ); 
	myfish.draw( bfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+8.0) ); 
	myfish.draw( bfish, vertbuff,uvbuff,elembuff );



	glbindtexture(gl_texture_2d, rfish_texid); -- 2 stingrays
	glUniform1f(wamp11, 1.0 ); --wiggle amplitude
	glUniform3f(icen11, 
		glfloat(fishx+0.8), glfloat(fishy), glfloat(fishz-0.8) );

	glUniform1f(time11, glfloat(currentTime+25.0) ); 
	myfish.draw( rfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+45.0) ); 
	myfish.draw( rfish, vertbuff,uvbuff,elembuff );




	-- school of piranha
	glUniform1i(arot11, -1 ); --RotSense(1=>CW, -1=>CCW)
	glbindtexture(gl_texture_2d, pfish_texid); -- piranha (?salt water?)
	glUniform3f(icen11, 0.0,glfloat(fishy-0.01),0.0 );
	glUniform1f(irad11, 2.0 ); --swim circle radius
	glUniform1f(svel11, 1.0 ); --swim speed
	glUniform1f(wvel11, 2.0 ); --wiggle speed
	glUniform1f(wamp11, 1.0 ); --wiggle amplitude

	glUniform1f(time11, glfloat(currentTime) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+3.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+10.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+12.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+20.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+21.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+30.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );

	glUniform1f(time11, glfloat(currentTime+32.0) ); 
	myfish.draw( pfish, vertbuff,uvbuff,elembuff );




	--shark
	glUniform1i(arot11, +1 ); --RotSense(1=>CW, -1=>CCW)

	glUniform1i(flev11, foglev); --new as of 12apr18

	glbindtexture(gl_texture_2d, sfish_texid); -- 3 sharks
	glUniform3f(icen11, 0.0, glfloat(sharky), 0.0 );
	glUniform1f(irad11, 11.0 ); --swim circle radius
	glUniform1f(svel11, 0.2 ); --swim speed
	glUniform1f(wvel11, 1.0 ); --wiggle speed
	glUniform1f(wamp11, 1.5 ); --wiggle amplitude

	glUniform1f(time11, glfloat(currentTime+0.0) ); 
	myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 

	glUniform1f(time11, glfloat(currentTime+45.0) ); 
	myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 

	glUniform1f(time11, glfloat(currentTime+90.0) ); 
	myfish.draw( sfish, vertbuff,uvbuff,elembuff ); 



	-- 1 serpents
	glbindtexture(gl_texture_2d, serpent_texid);
	glUniform3f(icen11, 0.0, glfloat(sharky), 0.0 );
	glUniform1f(irad11, 10.0 ); --swim circle radius
	glUniform1f(svel11, 0.2 ); --swim speed
	glUniform1f(wvel11, 1.0 ); --wiggle speed
	glUniform1f(wamp11, 1.5 ); --wiggle amplitude

	glUniform1f(time11, glfloat(currentTime+135.0) ); 
	longfish.draw( serpent, vertbuff,uvbuff,elembuff );



	-- 1 snake
	glbindtexture(gl_texture_2d, snake_texid);
	glUniform1i(arot11, -1 ); --RotSense(1=>CW, -1=>CCW)
	glUniform3f(icen11, 0.0, glfloat(sharky), 0.0 );
	glUniform1f(irad11, 9.5 ); --swim circle radius
	glUniform1f(svel11, 0.1 ); --swim speed
	glUniform1f(wvel11, 2.0 ); --wiggle speed
	glUniform1f(wamp11, 2.0 ); --wiggle amplitude

	glUniform1f(time11, glfloat(currentTime+0.0) ); 
	longtube.draw( snake, vertbuff,uvbuff,elembuff );



-------- draw fish here end ----------------------------------------




end drawfish;




