# Linux
# gnu compile script for adagate
# Test script that uses GNU-ada and GNU-g++
# rather than AdaCore compilers
#
# shows no advantage since glibc v2.14 is still required !
#########################################################

# use this to ensure a complete recompilation:
if [ -d ./obj/ ]; then
	rm ./obj/*
else
	mkdir obj
fi


# This step is not actually necessary
# since libsnd4ada.so is already present...
#
# prepares libsnd4ada.so file prior to gnatmake...
# using g++ from GNAT:

g++-4.9 adabindings/sfmlAudio/snd4ada.cpp -c -Werror -fPIC -I./cppinclude

g++-4.9 -shared -o ./libs/gnu/libsnd4ada.so snd4ada.o \
$PWD/libs/gnu/libsfml-audio.so \
$PWD/libs/gnu/libsfml-system.so


#########################################################


gnatmake adagate -o adagate_gnu_x \
-O3 -gnat12 \
--subdirs=./obj \
-I./adabindings/gl \
-I./adabindings/sdlada \
-I./adabindings/AdaPngLib \
-I./adabindings/sfmlAudio \
-largs \
-lGL -lz -lstdc++ \
-Xlinker -rpath='$ORIGIN/libs/gnu' \
-L$PWD/libs/gnu \
-lsnd4ada \
-lSDL2 -lsfml-audio -lsfml-system \
-lopenal -lcrypto -logg -lvorbis -lvorbisenc -lvorbisfile -lFLAC

#NOTE:  final line above has libs that need not be explicitly
#       mentioned, yet are used and may be non-standard



cp ./obj/adagate_gnu_x .


# -- Copyright (C) 2017  <fastrgv@gmail.com>
# --
# -- This program is free software: you can redistribute it and/or modify
# -- it under the terms of the GNU General Public License as published by
# -- the Free Software Foundation, either version 3 of the License, or
# -- (at your option) any later version.
# --
# -- This program is distributed in the hope that it will be useful,
# -- but WITHOUT ANY WARRANTY; without even the implied warranty of
# -- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# -- GNU General Public License for more details.
# --
# -- You may read the full text of the GNU General Public License
# -- at <http://www.gnu.org/licenses/>.



