#version 330 core
layout(location = 0) in vec3 vertexPos;
layout(location = 1) in vec2 vertexUV;
out vec2 UV;
uniform mat4 MVP;

uniform vec3 wPos;
uniform vec3 wRad;

const float bump=0.1;

void main(){

	// wRad.* = 0.01 (reminder)
	float rad2= ( wRad.x*wRad.x + wRad.y*wRad.y + wRad.z*wRad.z );
	// note: sqrt(rad2) = radius of sphere enclosing
	//       the original parallelpiped.

	vec3 pos = vertexPos;

	pos.x *= wRad.x;
	pos.y *= wRad.y;
	pos.z *= wRad.z;
	// we assume original setup with unitary radii

	pos.x += wPos.x;
	pos.y += wPos.y;
	pos.z += wPos.z; 
	// we assume original setup @ origin


	float 
		rx=(pos.x-wPos.x), 
		ry=(pos.y-wPos.y), 
		rz=(pos.z-wPos.z);

	// these values go from 1 @ corners
	// to sqrt(rad2) in the center of each face:
	float fyz = sqrt(rad2-(ry*ry+rz*rz)); // 1..rad
	float fxz = sqrt(rad2-(rx*rx+rz*rz)); // 1..rad
	float fxy = sqrt(rad2-(rx*rx+ry*ry)); // 1..rad

	// normalized offsets from center in [-1..1]:
	float nx=rx/wRad.x;
	float ny=ry/wRad.y;
	float nz=rz/wRad.z;

	// each face is inflated outward toward enclosing sphere
	// but eight corners of parallelpiped are preserved:
	pos.x = fyz * nx + wPos.x;
	pos.y = fxz * ny + wPos.y;
	pos.z = fxy * nz + wPos.z;



	gl_Position =  MVP * vec4(pos,1.0);
	UV = vertexUV;
}


//--
//-- Copyright (C) 2016  <fastrgv@gmail.com>
//--
//-- This program is free software: you can redistribute it and/or modify
//-- it under the terms of the GNU General Public License as published by
//-- the Free Software Foundation, either version 3 of the License, or
//-- (at your option) any later version.
//--
//-- This program is distributed in the hope that it will be useful,
//-- but WITHOUT ANY WARRANTY; without even the implied warranty of
//-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//-- GNU General Public License for more details.
//--
//-- You may read the full text of the GNU General Public License
//-- at <http://www.gnu.org/licenses/>.
//--

