import qs from 'qs';
import AddUrlRequest, { IAddUrlRequest } from 'Entities/AddUrlRequest';
import FilterCheckHostResponse, { IFilterCheckHostResponse } from 'Entities/FilterCheckHostResponse';
import FilterConfig, { IFilterConfig } from 'Entities/FilterConfig';
import FilterRefreshRequest, { IFilterRefreshRequest } from 'Entities/FilterRefreshRequest';
import FilterRefreshResponse, { IFilterRefreshResponse } from 'Entities/FilterRefreshResponse';
import FilterSetUrl, { IFilterSetUrl } from 'Entities/FilterSetUrl';
import FilterStatus, { IFilterStatus } from 'Entities/FilterStatus';
import RemoveUrlRequest, { IRemoveUrlRequest } from 'Entities/RemoveUrlRequest';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export default class FilteringApi {
    static async filteringAddURL(addurlrequest: IAddUrlRequest): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const addurlrequestValid = new AddUrlRequest(addurlrequest);
        haveError.push(...addurlrequestValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/filtering/add_url`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(addurlrequestValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringCheckHost(name?: string): Promise<IFilterCheckHostResponse | Error> {
        const queryParams = {
            name: name,
        }
        return await fetch(`/control/filtering/check_host?${qs.stringify(queryParams, { arrayFormat: 'comma' })}`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringConfig(filterconfig: IFilterConfig): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const filterconfigValid = new FilterConfig(filterconfig);
        haveError.push(...filterconfigValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/filtering/config`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(filterconfigValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringRefresh(filterrefreshrequest: IFilterRefreshRequest): Promise<IFilterRefreshResponse | string[] | Error> {
        const haveError: string[] = [];
        const filterrefreshrequestValid = new FilterRefreshRequest(filterrefreshrequest);
        haveError.push(...filterrefreshrequestValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/filtering/refresh`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(filterrefreshrequestValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringRemoveURL(removeurlrequest: IRemoveUrlRequest): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const removeurlrequestValid = new RemoveUrlRequest(removeurlrequest);
        haveError.push(...removeurlrequestValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/filtering/remove_url`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(removeurlrequestValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringSetRules(data: string): Promise<number | Error> {
        const params =  String(data);
        return await fetch(`/control/filtering/set_rules`, {
            method: 'POST',
            headers: {
                'Content-Type': 'text/plain',
            },
            body: params,
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringSetURL(filterseturl: IFilterSetUrl): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const filterseturlValid = new FilterSetUrl(filterseturl);
        haveError.push(...filterseturlValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/filtering/set_url`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(filterseturlValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async filteringStatus(): Promise<IFilterStatus | Error> {
        return await fetch(`/control/filtering/status`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }
}
