"use strict";
/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticCredentialProvider = exports.CredentialsProvider = void 0;
/**
 * CredentialsProvider Base Class. The base class of credentials providers.
 *
 * @category Auth
 */
var CredentialsProvider = /** @class */ (function () {
    function CredentialsProvider() {
    }
    /** Return a valid credentials. Please note mqtt.js does not support promises, meaning that credentials
     * provider implementation should handle application-level authentication refreshing so that the websocket
     * connection could simply grab the latest valid tokens when getCredentials() get called.
     *
     * @Returns AWSCredentials
     *
     * */
    CredentialsProvider.prototype.getCredentials = function () {
        return undefined;
    };
    return CredentialsProvider;
}());
exports.CredentialsProvider = CredentialsProvider;
/**
 * StaticCredentialProvider. The provider will always return the static AWSCredential.
 *
 * @category Auth
 */
var StaticCredentialProvider = /** @class */ (function (_super) {
    __extends(StaticCredentialProvider, _super);
    function StaticCredentialProvider(credentials) {
        var _this = _super.call(this) || this;
        _this.getCredentials = function () {
            return _this.credentials;
        };
        _this.credentials = credentials;
        return _this;
    }
    return StaticCredentialProvider;
}(CredentialsProvider));
exports.StaticCredentialProvider = StaticCredentialProvider;
//# sourceMappingURL=auth.js.map