"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/modulesMappers");
var Parameters = require("../models/parameters");
/** Class representing a Modules. */
var Modules = /** @class */ (function () {
    /**
     * Create a Modules.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function Modules(client) {
        this.client = client;
    }
    Modules.prototype.getTwin = function (id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            options: options
        }, getTwinOperationSpec, callback);
    };
    Modules.prototype.replaceTwin = function (id, mid, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            deviceTwinInfo: deviceTwinInfo,
            options: options
        }, replaceTwinOperationSpec, callback);
    };
    Modules.prototype.updateTwin = function (id, mid, deviceTwinInfo, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            deviceTwinInfo: deviceTwinInfo,
            options: options
        }, updateTwinOperationSpec, callback);
    };
    Modules.prototype.getModulesOnDevice = function (id, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            options: options
        }, getModulesOnDeviceOperationSpec, callback);
    };
    Modules.prototype.getIdentity = function (id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            options: options
        }, getIdentityOperationSpec, callback);
    };
    Modules.prototype.createOrUpdateIdentity = function (id, mid, module, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            module: module,
            options: options
        }, createOrUpdateIdentityOperationSpec, callback);
    };
    Modules.prototype.deleteIdentity = function (id, mid, options, callback) {
        return this.client.sendOperationRequest({
            id: id,
            mid: mid,
            options: options
        }, deleteIdentityOperationSpec, callback);
    };
    Modules.prototype.invokeMethod = function (deviceId, moduleId, directMethodRequest, options, callback) {
        return this.client.sendOperationRequest({
            deviceId: deviceId,
            moduleId: moduleId,
            directMethodRequest: directMethodRequest,
            options: options
        }, invokeMethodOperationSpec, callback);
    };
    return Modules;
}());
exports.Modules = Modules;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getTwinOperationSpec = {
    httpMethod: "GET",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var replaceTwinOperationSpec = {
    httpMethod: "PUT",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: __assign(__assign({}, Mappers.Twin), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var updateTwinOperationSpec = {
    httpMethod: "PATCH",
    path: "twins/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "deviceTwinInfo",
        mapper: __assign(__assign({}, Mappers.Twin), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Twin
        },
        default: {}
    },
    serializer: serializer
};
var getModulesOnDeviceOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}/modules",
    urlParameters: [
        Parameters.id
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "Module"
                        }
                    }
                }
            }
        },
        default: {}
    },
    serializer: serializer
};
var getIdentityOperationSpec = {
    httpMethod: "GET",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.Module
        },
        default: {}
    },
    serializer: serializer
};
var createOrUpdateIdentityOperationSpec = {
    httpMethod: "PUT",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    requestBody: {
        parameterPath: "module",
        mapper: __assign(__assign({}, Mappers.Module), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.Module
        },
        201: {
            bodyMapper: Mappers.Module
        },
        default: {}
    },
    serializer: serializer
};
var deleteIdentityOperationSpec = {
    httpMethod: "DELETE",
    path: "devices/{id}/modules/{mid}",
    urlParameters: [
        Parameters.id,
        Parameters.mid
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    headerParameters: [
        Parameters.ifMatch
    ],
    responses: {
        204: {},
        default: {}
    },
    serializer: serializer
};
var invokeMethodOperationSpec = {
    httpMethod: "POST",
    path: "twins/{deviceId}/modules/{moduleId}/methods",
    urlParameters: [
        Parameters.deviceId,
        Parameters.moduleId
    ],
    queryParameters: [
        Parameters.apiVersion
    ],
    requestBody: {
        parameterPath: "directMethodRequest",
        mapper: __assign(__assign({}, Mappers.CloudToDeviceMethod), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.CloudToDeviceMethodResult
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=modules.js.map