import { HttpClient, HttpForm } from "./http";
export interface InternalSubscription {
    open(next: ((value: any) => void), error?: (error: any) => void, complete?: () => void): void;
    close(): void;
}
export declare class LongPollingSubscription implements InternalSubscription {
    private form;
    private client;
    private closed;
    constructor(form: HttpForm, client: HttpClient);
    open(next: ((value: any) => void), error?: (error: any) => void, complete?: () => void): void;
    close(): void;
}
export declare class SSESubscription implements InternalSubscription {
    private form;
    private eventSource;
    private closed;
    constructor(form: HttpForm);
    open(next: ((value: any) => void), error?: (error: any) => void, complete?: () => void): void;
    close(): void;
}
