/// <reference types="node" />
import { Dirent } from 'fs';
export declare type DirentAction = (dirent: Dirent) => void;
export declare type CheckPathFunc = (nextPath: string) => boolean;
export declare function fileExists(filePath: string): Promise<boolean>;
export declare function forEachDirentAsync(dirPath: string, action: DirentAction): Promise<void>;
export declare function readDirectory(dirPath: string): Promise<string[]>;
export declare function removeEmptyDirsUp(checkedDirs: Set<string>, dirPath: string, count?: number): Promise<number>;
export declare function crawlDirFast(filePaths: string[], dirPath: string): Promise<void>;
export declare function crawlDirWithChecks(filePaths: string[], dirPath: string, checkDir: CheckPathFunc, checkFile: CheckPathFunc): Promise<string[]>;
