import { Service } from "../Service";
/**
 * Service "Access Code"
 * @since iOS 15
 */
export declare class AccessCode extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Access Control"
 */
export declare class AccessControl extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Accessory Information"
 */
export declare class AccessoryInformation extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Accessory Metrics"
 */
export declare class AccessoryMetrics extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Accessory Runtime Information"
 */
export declare class AccessoryRuntimeInformation extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Air Purifier"
 */
export declare class AirPurifier extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Air Quality Sensor"
 */
export declare class AirQualitySensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Asset Update"
 */
export declare class AssetUpdate extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Assistant"
 */
export declare class Assistant extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Audio Stream Management"
 */
export declare class AudioStreamManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Battery"
 */
export declare class Battery extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Bridge Configuration"
 * @deprecated Removed and not used anymore
 */
export declare class BridgeConfiguration extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Bridging State"
 * @deprecated Removed and not used anymore
 */
export declare class BridgingState extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Camera Control"
 * @deprecated This service has no usage anymore and will be ignored by iOS
 */
export declare class CameraControl extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Camera Operating Mode"
 */
export declare class CameraOperatingMode extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Camera Recording Management"
 */
export declare class CameraRecordingManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Camera RTP Stream Management"
 */
export declare class CameraRTPStreamManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Carbon Dioxide Sensor"
 */
export declare class CarbonDioxideSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Carbon Monoxide Sensor"
 */
export declare class CarbonMonoxideSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Cloud Relay"
 */
export declare class CloudRelay extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Contact Sensor"
 */
export declare class ContactSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Data Stream Transport Management"
 */
export declare class DataStreamTransportManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Diagnostics"
 */
export declare class Diagnostics extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Door"
 */
export declare class Door extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Doorbell"
 */
export declare class Doorbell extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Fan"
 */
export declare class Fan extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Fanv2"
 */
export declare class Fanv2 extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Faucet"
 */
export declare class Faucet extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Filter Maintenance"
 */
export declare class FilterMaintenance extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Garage Door Opener"
 */
export declare class GarageDoorOpener extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Heater-Cooler"
 */
export declare class HeaterCooler extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Humidifier-Dehumidifier"
 */
export declare class HumidifierDehumidifier extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Humidity Sensor"
 */
export declare class HumiditySensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Input Source"
 */
export declare class InputSource extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Irrigation-System"
 */
export declare class IrrigationSystem extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Leak Sensor"
 */
export declare class LeakSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Lightbulb"
 */
export declare class Lightbulb extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Light Sensor"
 */
export declare class LightSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Lock Management"
 */
export declare class LockManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Lock Mechanism"
 */
export declare class LockMechanism extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Microphone"
 */
export declare class Microphone extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Motion Sensor"
 */
export declare class MotionSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "NFC Access"
 * @since iOS 15
 */
export declare class NFCAccess extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Occupancy Sensor"
 */
export declare class OccupancySensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Outlet"
 * @since iOS 13
 */
export declare class Outlet extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Pairing"
 */
export declare class Pairing extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Power Management"
 */
export declare class PowerManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Protocol Information"
 */
export declare class ProtocolInformation extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Security System"
 */
export declare class SecuritySystem extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Service Label"
 */
export declare class ServiceLabel extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Siri"
 */
export declare class Siri extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Siri Endpoint"
 */
export declare class SiriEndpoint extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Slats"
 */
export declare class Slats extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Smart Speaker"
 */
export declare class SmartSpeaker extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Smoke Sensor"
 */
export declare class SmokeSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Speaker"
 * @since iOS 10
 */
export declare class Speaker extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Stateful Programmable Switch"
 */
export declare class StatefulProgrammableSwitch extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Stateless Programmable Switch"
 */
export declare class StatelessProgrammableSwitch extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Switch"
 */
export declare class Switch extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Target Control"
 */
export declare class TargetControl extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Target Control Management"
 */
export declare class TargetControlManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Television"
 */
export declare class Television extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Television Speaker"
 */
export declare class TelevisionSpeaker extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Temperature Sensor"
 */
export declare class TemperatureSensor extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Thermostat"
 */
export declare class Thermostat extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Thread Transport"
 */
export declare class ThreadTransport extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Time Information"
 * @deprecated Removed and not used anymore
 */
export declare class TimeInformation extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Transfer Transport Management"
 */
export declare class TransferTransportManagement extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Tunnel"
 */
export declare class Tunnel extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Valve"
 */
export declare class Valve extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Wi-Fi Router"
 */
export declare class WiFiRouter extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Wi-Fi Satellite"
 */
export declare class WiFiSatellite extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Wi-Fi Transport"
 */
export declare class WiFiTransport extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Window"
 */
export declare class Window extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
/**
 * Service "Window Covering"
 */
export declare class WindowCovering extends Service {
    static readonly UUID: string;
    constructor(displayName?: string, subtype?: string);
}
//# sourceMappingURL=ServiceDefinitions.d.ts.map