import { BasicAccessory, ServiceHandler } from '../interfaces';
import { ExposesEntryWithBinaryProperty, ExposesEntryWithProperty } from '../../z2mModels';
import { CharacteristicMonitor } from '../monitor';
import { Service } from 'homebridge';
export interface ServiceConstructor {
    (serviceName: string, subType: string | undefined): Service;
}
export interface IdentifierGenerator {
    (endpoint: string | undefined, accessory: BasicAccessory): string;
}
export declare abstract class BasicSensorHandler implements ServiceHandler {
    protected readonly sensorExpose: ExposesEntryWithProperty;
    protected monitors: CharacteristicMonitor[];
    protected tamperExpose?: ExposesEntryWithBinaryProperty;
    protected lowBatteryExpose?: ExposesEntryWithBinaryProperty;
    protected service: Service;
    protected serviceName: string;
    identifier: string;
    constructor(accessory: BasicAccessory, sensorExpose: ExposesEntryWithProperty, otherExposes: ExposesEntryWithBinaryProperty[], identifierGen: IdentifierGenerator, service: ServiceConstructor, additionalSubType?: string | undefined);
    get getableKeys(): string[];
    protected createOptionalGenericCharacteristics(exposes: ExposesEntryWithBinaryProperty[], service: Service): void;
    private tryCreateTamper;
    private tryCreateLowBattery;
    updateState(state: Record<string, unknown>): void;
}
//# sourceMappingURL=basic.d.ts.map