import { ExposesEntry } from '../z2mModels';
import { BasicAccessory, ConverterConfigurationRegistry } from './interfaces';
import { BasicLogger } from '../logger';
import { Logger } from 'homebridge';
export interface ServiceCreatorManager {
    createHomeKitEntitiesFromExposes(accessory: BasicAccessory, exposes: ExposesEntry[]): void;
}
export interface ConverterConfigValidatorCollection {
    allConverterConfigurationsAreValid(configurations: object, logger: BasicLogger | undefined): boolean;
}
export declare class BasicServiceCreatorManager implements ServiceCreatorManager, ConverterConfigValidatorCollection, ConverterConfigurationRegistry {
    private static readonly constructors;
    private static instance;
    private creators;
    private converterConfigs;
    private constructor();
    allConverterConfigurationsAreValid(configurations: object, logger: Logger | undefined): boolean;
    registerConverterConfiguration(tag: string, validator: (config: unknown, tag: string, logger: Logger | undefined) => boolean): void;
    static getInstance(): BasicServiceCreatorManager;
    createHomeKitEntitiesFromExposes(accessory: BasicAccessory, exposes: ExposesEntry[]): void;
}
//# sourceMappingURL=creators.d.ts.map