import { Characteristic, CharacteristicValue, Service, WithUUID } from 'homebridge';
export interface MqttToHomeKitValueTransformer {
    (value: unknown): CharacteristicValue | undefined;
}
export interface CharacteristicMonitor {
    callback(state: Record<string, unknown>): void;
}
declare abstract class BaseCharacteristicMonitor implements CharacteristicMonitor {
    private readonly key;
    protected readonly service: Service;
    protected readonly characteristic: string | WithUUID<new () => Characteristic>;
    constructor(key: string, service: Service, characteristic: string | WithUUID<new () => Characteristic>);
    abstract transformValueFromMqtt(value: unknown): CharacteristicValue | undefined;
    callback(state: Record<string, unknown>): void;
}
export declare class NestedCharacteristicMonitor implements CharacteristicMonitor {
    private readonly key;
    private readonly monitors;
    constructor(key: string, monitors: CharacteristicMonitor[]);
    callback(state: Record<string, unknown>): void;
}
export declare class PassthroughCharacteristicMonitor extends BaseCharacteristicMonitor {
    constructor(key: string, service: Service, characteristic: string | WithUUID<new () => Characteristic>);
    transformValueFromMqtt(value: unknown): CharacteristicValue | undefined;
}
export declare class MappingCharacteristicMonitor extends BaseCharacteristicMonitor {
    private readonly mapping;
    constructor(key: string, service: Service, characteristic: string | WithUUID<new () => Characteristic>, mapping: Map<CharacteristicValue, CharacteristicValue>);
    transformValueFromMqtt(value: unknown): CharacteristicValue | undefined;
}
export interface BinaryConditionBasedOnValue {
    (value: unknown): boolean;
}
export declare class BinaryConditionCharacteristicMonitor extends BaseCharacteristicMonitor {
    private readonly condition;
    private readonly value_true;
    private readonly value_false;
    constructor(key: string, service: Service, characteristic: string | WithUUID<new () => Characteristic>, condition: BinaryConditionBasedOnValue, value_true: CharacteristicValue, value_false: CharacteristicValue);
    transformValueFromMqtt(value: unknown): CharacteristicValue | undefined;
}
export declare class NumericCharacteristicMonitor extends BaseCharacteristicMonitor {
    private readonly input_min;
    private readonly input_max;
    private readonly output_min?;
    private readonly output_max?;
    constructor(key: string, service: Service, characteristic: string | WithUUID<new () => Characteristic>, input_min: number, input_max: number, output_min?: number | undefined, output_max?: number | undefined);
    transformValueFromMqtt(value: unknown): CharacteristicValue | undefined;
}
export {};
//# sourceMappingURL=monitor.d.ts.map