// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package proto

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// SignalExchangeClient is the client API for SignalExchange service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SignalExchangeClient interface {
	// Synchronously connect to the Signal Exchange service offering connection candidates and waiting for connection candidates from the other party (remote peer)
	Send(ctx context.Context, in *EncryptedMessage, opts ...grpc.CallOption) (*EncryptedMessage, error)
	// Connect to the Signal Exchange service offering connection candidates and maintain a channel for receiving candidates from the other party (remote peer)
	ConnectStream(ctx context.Context, opts ...grpc.CallOption) (SignalExchange_ConnectStreamClient, error)
}

type signalExchangeClient struct {
	cc grpc.ClientConnInterface
}

func NewSignalExchangeClient(cc grpc.ClientConnInterface) SignalExchangeClient {
	return &signalExchangeClient{cc}
}

func (c *signalExchangeClient) Send(ctx context.Context, in *EncryptedMessage, opts ...grpc.CallOption) (*EncryptedMessage, error) {
	out := new(EncryptedMessage)
	err := c.cc.Invoke(ctx, "/signalexchange.SignalExchange/Send", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *signalExchangeClient) ConnectStream(ctx context.Context, opts ...grpc.CallOption) (SignalExchange_ConnectStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &SignalExchange_ServiceDesc.Streams[0], "/signalexchange.SignalExchange/ConnectStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &signalExchangeConnectStreamClient{stream}
	return x, nil
}

type SignalExchange_ConnectStreamClient interface {
	Send(*EncryptedMessage) error
	Recv() (*EncryptedMessage, error)
	grpc.ClientStream
}

type signalExchangeConnectStreamClient struct {
	grpc.ClientStream
}

func (x *signalExchangeConnectStreamClient) Send(m *EncryptedMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *signalExchangeConnectStreamClient) Recv() (*EncryptedMessage, error) {
	m := new(EncryptedMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SignalExchangeServer is the server API for SignalExchange service.
// All implementations must embed UnimplementedSignalExchangeServer
// for forward compatibility
type SignalExchangeServer interface {
	// Synchronously connect to the Signal Exchange service offering connection candidates and waiting for connection candidates from the other party (remote peer)
	Send(context.Context, *EncryptedMessage) (*EncryptedMessage, error)
	// Connect to the Signal Exchange service offering connection candidates and maintain a channel for receiving candidates from the other party (remote peer)
	ConnectStream(SignalExchange_ConnectStreamServer) error
	mustEmbedUnimplementedSignalExchangeServer()
}

// UnimplementedSignalExchangeServer must be embedded to have forward compatible implementations.
type UnimplementedSignalExchangeServer struct {
}

func (UnimplementedSignalExchangeServer) Send(context.Context, *EncryptedMessage) (*EncryptedMessage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Send not implemented")
}
func (UnimplementedSignalExchangeServer) ConnectStream(SignalExchange_ConnectStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method ConnectStream not implemented")
}
func (UnimplementedSignalExchangeServer) mustEmbedUnimplementedSignalExchangeServer() {}

// UnsafeSignalExchangeServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SignalExchangeServer will
// result in compilation errors.
type UnsafeSignalExchangeServer interface {
	mustEmbedUnimplementedSignalExchangeServer()
}

func RegisterSignalExchangeServer(s grpc.ServiceRegistrar, srv SignalExchangeServer) {
	s.RegisterService(&SignalExchange_ServiceDesc, srv)
}

func _SignalExchange_Send_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EncryptedMessage)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SignalExchangeServer).Send(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/signalexchange.SignalExchange/Send",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SignalExchangeServer).Send(ctx, req.(*EncryptedMessage))
	}
	return interceptor(ctx, in, info, handler)
}

func _SignalExchange_ConnectStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SignalExchangeServer).ConnectStream(&signalExchangeConnectStreamServer{stream})
}

type SignalExchange_ConnectStreamServer interface {
	Send(*EncryptedMessage) error
	Recv() (*EncryptedMessage, error)
	grpc.ServerStream
}

type signalExchangeConnectStreamServer struct {
	grpc.ServerStream
}

func (x *signalExchangeConnectStreamServer) Send(m *EncryptedMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *signalExchangeConnectStreamServer) Recv() (*EncryptedMessage, error) {
	m := new(EncryptedMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SignalExchange_ServiceDesc is the grpc.ServiceDesc for SignalExchange service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SignalExchange_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "signalexchange.SignalExchange",
	HandlerType: (*SignalExchangeServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Send",
			Handler:    _SignalExchange_Send_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ConnectStream",
			Handler:       _SignalExchange_ConnectStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "signalexchange.proto",
}
