"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const logger_1 = require("@nrchkb/logger");
const hap_nodejs_1 = require("hap-nodejs");
const log = (0, logger_1.logger)('NRCHKB', 'HAPStatusNode');
module.exports = (RED) => {
    log.debug('Registering homekit-status type');
    RED.nodes.registerType('homekit-status', function (config) {
        const self = this;
        self.config = config;
        RED.nodes.createNode(self, config);
        self.lastStatusId = 0;
        self.setStatus = (status, timeout) => {
            self.status(status);
            self.lastStatusId = new Date().getTime();
            if (timeout) {
                self.clearStatus(self.lastStatusId, timeout);
            }
            return self.lastStatusId;
        };
        self.clearStatus = (statusId, delay) => {
            if (statusId === self.lastStatusId) {
                if (delay) {
                    setTimeout(function () {
                        self.setStatus({});
                    }, delay);
                }
                else {
                    self.setStatus({});
                }
            }
        };
        try {
            self.serviceNode = RED.nodes.getNode(self.config.serviceNodeId);
        }
        catch (error) {
            log.error(error);
        }
        self.on('input', (_) => {
            if (self.serviceNode) {
                self.setStatus({
                    fill: 'green',
                    shape: 'dot',
                    text: 'Done',
                }, 3000);
                const serializedService = hap_nodejs_1.Service.serialize(self.serviceNode.service);
                self.send({
                    payload: serializedService,
                });
            }
            else {
                self.setStatus({
                    fill: 'red',
                    shape: 'dot',
                    text: 'Check your config',
                }, 3000);
            }
        });
        self.on('close', (_, done) => {
            self.serviceNode = undefined;
            done();
        });
    });
};
