'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../../base/deserialize');  /* jshint ignore:line */
var values = require('../../../../base/values');  /* jshint ignore:line */

var SubscribedEventList;
var SubscribedEventPage;
var SubscribedEventInstance;
var SubscribedEventContext;

/* jshint ignore:start */
/**
 * Initialize the SubscribedEventList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionContext.SubscribedEventList
 *
 * @param {Twilio.Events.V1} version - Version of the resource
 * @param {string} subscriptionSid - Subscription SID.
 */
/* jshint ignore:end */
SubscribedEventList = function SubscribedEventList(version, subscriptionSid) {
  /* jshint ignore:start */
  /**
   * @function subscribedEvents
   * @memberof Twilio.Events.V1.SubscriptionContext#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Events.V1.SubscriptionContext.SubscribedEventContext}
   */
  /* jshint ignore:end */
  function SubscribedEventListInstance(sid) {
    return SubscribedEventListInstance.get(sid);
  }

  SubscribedEventListInstance._version = version;
  // Path Solution
  SubscribedEventListInstance._solution = {subscriptionSid: subscriptionSid};
  SubscribedEventListInstance._uri = `/Subscriptions/${subscriptionSid}/SubscribedEvents`;
  /* jshint ignore:start */
  /**
   * Streams SubscribedEventInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists SubscribedEventInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of SubscribedEventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscribedEventPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of SubscribedEventInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscribedEventPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * create a SubscribedEventInstance
   *
   * @function create
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.type - Type of event being subscribed to.
   * @param {number} [opts.schemaVersion] -
   *          The schema version that the subscription should use.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed SubscribedEventInstance
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.type)) {
      throw new Error('Required parameter "opts.type" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({'Type': _.get(opts, 'type'), 'SchemaVersion': _.get(opts, 'schemaVersion')});

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new SubscribedEventInstance(
        this._version,
        payload,
        this._solution.subscriptionSid,
        this._solution.type
      ));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a subscribed_event
   *
   * @function get
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @param {string} type - Type of event being subscribed to.
   *
   * @returns {Twilio.Events.V1.SubscriptionContext.SubscribedEventContext}
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.get = function get(type) {
    return new SubscribedEventContext(this._version, this._solution.subscriptionSid, type);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  SubscribedEventListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  SubscribedEventListInstance[util.inspect.custom] = function inspect(depth,
      options) {
    return util.inspect(this.toJSON(), options);
  };

  return SubscribedEventListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedEventPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionContext.SubscribedEventPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {SubscribedEventSolution} solution - Path solution
 *
 * @returns SubscribedEventPage
 */
/* jshint ignore:end */
SubscribedEventPage = function SubscribedEventPage(version, response, solution)
                                                    {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(SubscribedEventPage.prototype, Page.prototype);
SubscribedEventPage.prototype.constructor = SubscribedEventPage;

/* jshint ignore:start */
/**
 * Build an instance of SubscribedEventInstance
 *
 * @function getInstance
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventPage#
 *
 * @param {SubscribedEventPayload} payload - Payload response from the API
 *
 * @returns SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventPage.prototype.getInstance = function getInstance(payload) {
  return new SubscribedEventInstance(this._version, payload, this._solution.subscriptionSid);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedEventPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscribedEventPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedEventContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionContext.SubscribedEventInstance
 *
 * @property {string} accountSid - Account SID.
 * @property {string} type - Type of event being subscribed to.
 * @property {number} schemaVersion -
 *          The schema version that the subscription should use.
 * @property {string} subscriptionSid - Subscription SID.
 * @property {string} url - The URL of this resource.
 *
 * @param {V1} version - Version of the resource
 * @param {SubscribedEventPayload} payload - The instance payload
 * @param {sid} subscriptionSid - Subscription SID.
 * @param {string} type - Type of event being subscribed to.
 */
/* jshint ignore:end */
SubscribedEventInstance = function SubscribedEventInstance(version, payload,
                                                            subscriptionSid,
                                                            type) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.type = payload.type; // jshint ignore:line
  this.schemaVersion = deserialize.integer(payload.schema_version); // jshint ignore:line
  this.subscriptionSid = payload.subscription_sid; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {subscriptionSid: subscriptionSid, type: type || this.type, };
};

Object.defineProperty(SubscribedEventInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new SubscribedEventContext(
          this._version,
          this._solution.subscriptionSid,
          this._solution.type
        );
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a SubscribedEventInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * update a SubscribedEventInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.schemaVersion] -
 *          The schema version that the subscription should use.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * remove a SubscribedEventInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedEventInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

SubscribedEventInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the SubscribedEventContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Events.V1.SubscriptionContext.SubscribedEventContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} subscriptionSid - Subscription SID.
 * @param {string} type - Type of event being subscribed to.
 */
/* jshint ignore:end */
SubscribedEventContext = function SubscribedEventContext(version,
                                                          subscriptionSid, type)
                                                          {
  this._version = version;

  // Path Solution
  this._solution = {subscriptionSid: subscriptionSid, type: type, };
  this._uri = `/Subscriptions/${subscriptionSid}/SubscribedEvents/${type}`;
};

/* jshint ignore:start */
/**
 * fetch a SubscribedEventInstance
 *
 * @function fetch
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new SubscribedEventInstance(
      this._version,
      payload,
      this._solution.subscriptionSid,
      this._solution.type
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * update a SubscribedEventInstance
 *
 * @function update
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventContext#
 *
 * @param {object} [opts] - Options for request
 * @param {number} [opts.schemaVersion] -
 *          The schema version that the subscription should use.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({'SchemaVersion': _.get(opts, 'schemaVersion')});

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new SubscribedEventInstance(
      this._version,
      payload,
      this._solution.subscriptionSid,
      this._solution.type
    ));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a SubscribedEventInstance
 *
 * @function remove
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed SubscribedEventInstance
 */
/* jshint ignore:end */
SubscribedEventContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Events.V1.SubscriptionContext.SubscribedEventContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
SubscribedEventContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

SubscribedEventContext.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  SubscribedEventList: SubscribedEventList,
  SubscribedEventPage: SubscribedEventPage,
  SubscribedEventInstance: SubscribedEventInstance,
  SubscribedEventContext: SubscribedEventContext
};
