'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./flexApi/V1');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize flex_api domain
 *
 * @constructor Twilio.FlexApi
 *
 * @property {Twilio.FlexApi.V1} v1 - v1 version
 * @property {Twilio.FlexApi.V1.ChannelList} channel - channel resource
 * @property {Twilio.FlexApi.V1.ConfigurationList} configuration -
 *          configuration resource
 * @property {Twilio.FlexApi.V1.FlexFlowList} flexFlow - flexFlow resource
 * @property {Twilio.FlexApi.V1.WebChannelList} webChannel - webChannel resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function FlexApi(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://flex-api.twilio.com');

  // Versions
  this._v1 = undefined;
}

_.extend(FlexApi.prototype, Domain.prototype);
FlexApi.prototype.constructor = FlexApi;

Object.defineProperty(FlexApi.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(FlexApi.prototype,
  'channel', {
    get: function() {
      return this.v1.channel;
    }
});

Object.defineProperty(FlexApi.prototype,
  'configuration', {
    get: function() {
      return this.v1.configuration;
    }
});

Object.defineProperty(FlexApi.prototype,
  'flexFlow', {
    get: function() {
      return this.v1.flexFlow;
    }
});

Object.defineProperty(FlexApi.prototype,
  'webChannel', {
    get: function() {
      return this.v1.webChannel;
    }
});

module.exports = FlexApi;
