'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var Domain = require('../base/Domain');  /* jshint ignore:line */
var V1 = require('./trunking/V1');  /* jshint ignore:line */


/* jshint ignore:start */
/**
 * Initialize trunking domain
 *
 * @constructor Twilio.Trunking
 *
 * @property {Twilio.Trunking.V1} v1 - v1 version
 * @property {Twilio.Trunking.V1.TrunkList} trunks - trunks resource
 *
 * @param {Twilio} twilio - The twilio client
 */
/* jshint ignore:end */
function Trunking(twilio) {
  Domain.prototype.constructor.call(this, twilio, 'https://trunking.twilio.com');

  // Versions
  this._v1 = undefined;
}

_.extend(Trunking.prototype, Domain.prototype);
Trunking.prototype.constructor = Trunking;

Object.defineProperty(Trunking.prototype,
  'v1', {
    get: function() {
      this._v1 = this._v1 || new V1(this);
      return this._v1;
    }
});

Object.defineProperty(Trunking.prototype,
  'trunks', {
    get: function() {
      return this.v1.trunks;
    }
});

module.exports = Trunking;
