'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var ParticipantList = require('./room/participant').ParticipantList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var RoomList;
var RoomPage;
var RoomInstance;
var RoomContext;

/* jshint ignore:start */
/**
 * Initialize the RoomList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Insights.V1.RoomList
 *
 * @param {Twilio.Insights.V1} version - Version of the resource
 */
/* jshint ignore:end */
RoomList = function RoomList(version) {
  /* jshint ignore:start */
  /**
   * @function rooms
   * @memberof Twilio.Insights.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Insights.V1.RoomContext}
   */
  /* jshint ignore:end */
  function RoomListInstance(sid) {
    return RoomListInstance.get(sid);
  }

  RoomListInstance._version = version;
  // Path Solution
  RoomListInstance._solution = {};
  RoomListInstance._uri = `/Video/Rooms`;
  /* jshint ignore:start */
  /**
   * Streams RoomInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @param {object} [opts] - Options for request
   * @param {room.room_type|list} [opts.roomType] - Type of room.
   * @param {room.codec|list} [opts.codec] - Codecs used by participants in the room.
   * @param {string} [opts.roomName] - Room friendly name.
   * @param {Date} [opts.createdAfter] -
   *          Only read rooms that started on or after this ISO 8601 timestamp.
   * @param {Date} [opts.createdBefore] -
   *          Only read rooms that started before this ISO 8601 timestamp.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  RoomListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists RoomInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @param {object} [opts] - Options for request
   * @param {room.room_type|list} [opts.roomType] - Type of room.
   * @param {room.codec|list} [opts.codec] - Codecs used by participants in the room.
   * @param {string} [opts.roomName] - Room friendly name.
   * @param {Date} [opts.createdAfter] -
   *          Only read rooms that started on or after this ISO 8601 timestamp.
   * @param {Date} [opts.createdBefore] -
   *          Only read rooms that started before this ISO 8601 timestamp.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RoomListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @param {object} [opts] - Options for request
   * @param {room.room_type|list} [opts.roomType] - Type of room.
   * @param {room.codec|list} [opts.codec] - Codecs used by participants in the room.
   * @param {string} [opts.roomName] - Room friendly name.
   * @param {Date} [opts.createdAfter] -
   *          Only read rooms that started on or after this ISO 8601 timestamp.
   * @param {Date} [opts.createdBefore] -
   *          Only read rooms that started before this ISO 8601 timestamp.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RoomListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'RoomType': serialize.map(_.get(opts, 'roomType'), function(e) { return e; }),
      'Codec': serialize.map(_.get(opts, 'codec'), function(e) { return e; }),
      'RoomName': _.get(opts, 'roomName'),
      'CreatedAfter': serialize.iso8601DateTime(_.get(opts, 'createdAfter')),
      'CreatedBefore': serialize.iso8601DateTime(_.get(opts, 'createdBefore')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new RoomPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of RoomInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  RoomListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new RoomPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a room
   *
   * @function get
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @param {string} roomSid - The SID of the Room resource.
   *
   * @returns {Twilio.Insights.V1.RoomContext}
   */
  /* jshint ignore:end */
  RoomListInstance.get = function get(roomSid) {
    return new RoomContext(this._version, roomSid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Insights.V1.RoomList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  RoomListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  RoomListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return RoomListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the RoomPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Insights.V1.RoomPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {RoomSolution} solution - Path solution
 *
 * @returns RoomPage
 */
/* jshint ignore:end */
RoomPage = function RoomPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(RoomPage.prototype, Page.prototype);
RoomPage.prototype.constructor = RoomPage;

/* jshint ignore:start */
/**
 * Build an instance of RoomInstance
 *
 * @function getInstance
 * @memberof Twilio.Insights.V1.RoomPage#
 *
 * @param {RoomPayload} payload - Payload response from the API
 *
 * @returns RoomInstance
 */
/* jshint ignore:end */
RoomPage.prototype.getInstance = function getInstance(payload) {
  return new RoomInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.RoomPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
RoomPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RoomPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RoomContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Insights.V1.RoomInstance
 *
 * @property {string} accountSid - Account SID associated with this room.
 * @property {string} roomSid - Unique identifier for the room.
 * @property {string} roomName - room friendly name.
 * @property {Date} createTime - Creation time of the room.
 * @property {Date} endTime - End time for the room.
 * @property {room.room_type} roomType - Type of room.
 * @property {room.room_status} roomStatus - Status of the room.
 * @property {string} statusCallback - Webhook provided for status callbacks.
 * @property {string} statusCallbackMethod -
 *          HTTP method provided for status callback URL.
 * @property {room.created_method} createdMethod - How the room was created.
 * @property {room.end_reason} endReason - Reason the room ended.
 * @property {number} maxParticipants -
 *          Max number of total participants allowed by the application settings.
 * @property {number} uniqueParticipants -
 *          Number of participants. May include duplicate identities for participants who left and rejoined.
 * @property {number} uniqueParticipantIdentities -
 *          Unique number of participant identities.
 * @property {number} concurrentParticipants -
 *          Actual number of concurrent participants.
 * @property {number} maxConcurrentParticipants -
 *          Maximum number of participants allowed in the room at the same time allowed by the application settings.
 * @property {room.codec} codecs - Codecs used by participants in the room.
 * @property {room.twilio_realm} mediaRegion -
 *          Region of Twilio media servers for the room.
 * @property {number} durationSec -
 *          Total room duration from create time to end time.
 * @property {number} totalParticipantDurationSec -
 *          Combined amount of participant time in the room.
 * @property {number} totalRecordingDurationSec -
 *          Combined amount of recorded seconds for participants in the room.
 * @property {room.processing_state} processingState -
 *          Video Log Analyzer resource state. Will be either `in-progress` or `complete`.
 * @property {boolean} recordingEnabled -
 *          Boolean indicating if recording is enabled for the room.
 * @property {room.edge_location} edgeLocation -
 *          Edge location of Twilio media servers for the room.
 * @property {string} url - URL for the room resource.
 * @property {string} links - Room subresources.
 *
 * @param {V1} version - Version of the resource
 * @param {RoomPayload} payload - The instance payload
 * @param {sid_like} roomSid - The SID of the Room resource.
 */
/* jshint ignore:end */
RoomInstance = function RoomInstance(version, payload, roomSid) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.roomSid = payload.room_sid; // jshint ignore:line
  this.roomName = payload.room_name; // jshint ignore:line
  this.createTime = deserialize.iso8601DateTime(payload.create_time); // jshint ignore:line
  this.endTime = deserialize.iso8601DateTime(payload.end_time); // jshint ignore:line
  this.roomType = payload.room_type; // jshint ignore:line
  this.roomStatus = payload.room_status; // jshint ignore:line
  this.statusCallback = payload.status_callback; // jshint ignore:line
  this.statusCallbackMethod = payload.status_callback_method; // jshint ignore:line
  this.createdMethod = payload.created_method; // jshint ignore:line
  this.endReason = payload.end_reason; // jshint ignore:line
  this.maxParticipants = deserialize.integer(payload.max_participants); // jshint ignore:line
  this.uniqueParticipants = deserialize.integer(payload.unique_participants); // jshint ignore:line
  this.uniqueParticipantIdentities = deserialize.integer(payload.unique_participant_identities); // jshint ignore:line
  this.concurrentParticipants = deserialize.integer(payload.concurrent_participants); // jshint ignore:line
  this.maxConcurrentParticipants = deserialize.integer(payload.max_concurrent_participants); // jshint ignore:line
  this.codecs = payload.codecs; // jshint ignore:line
  this.mediaRegion = payload.media_region; // jshint ignore:line
  this.durationSec = deserialize.integer(payload.duration_sec); // jshint ignore:line
  this.totalParticipantDurationSec = deserialize.integer(payload.total_participant_duration_sec); // jshint ignore:line
  this.totalRecordingDurationSec = deserialize.integer(payload.total_recording_duration_sec); // jshint ignore:line
  this.processingState = payload.processing_state; // jshint ignore:line
  this.recordingEnabled = payload.recording_enabled; // jshint ignore:line
  this.edgeLocation = payload.edge_location; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {roomSid: roomSid || this.roomSid, };
};

Object.defineProperty(RoomInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new RoomContext(this._version, this._solution.roomSid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a RoomInstance
 *
 * @function fetch
 * @memberof Twilio.Insights.V1.RoomInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RoomInstance
 */
/* jshint ignore:end */
RoomInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Access the participants
 *
 * @function participants
 * @memberof Twilio.Insights.V1.RoomInstance#
 *
 * @returns {Twilio.Insights.V1.RoomContext.ParticipantList}
 */
/* jshint ignore:end */
RoomInstance.prototype.participants = function participants() {
  return this._proxy.participants;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.RoomInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
RoomInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

RoomInstance.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the RoomContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Insights.V1.RoomContext
 *
 * @property {Twilio.Insights.V1.RoomContext.ParticipantList} participants -
 *          participants resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid_like} roomSid - The SID of the Room resource.
 */
/* jshint ignore:end */
RoomContext = function RoomContext(version, roomSid) {
  this._version = version;

  // Path Solution
  this._solution = {roomSid: roomSid, };
  this._uri = `/Video/Rooms/${roomSid}`;

  // Dependents
  this._participants = undefined;
};

/* jshint ignore:start */
/**
 * fetch a RoomInstance
 *
 * @function fetch
 * @memberof Twilio.Insights.V1.RoomContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed RoomInstance
 */
/* jshint ignore:end */
RoomContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new RoomInstance(this._version, payload, this._solution.roomSid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(RoomContext.prototype,
  'participants', {
    get: function() {
      if (!this._participants) {
        this._participants = new ParticipantList(this._version, this._solution.roomSid);
      }
      return this._participants;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Insights.V1.RoomContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
RoomContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

RoomContext.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  RoomList: RoomList,
  RoomPage: RoomPage,
  RoomInstance: RoomInstance,
  RoomContext: RoomContext
};
