/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V1 = require('../../V1');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the CustomerProfilesEntityAssignmentsList
 *
 * @param version - Version of the resource
 * @param customerProfileSid - The unique string that identifies the CustomerProfile resource.
 */
declare function CustomerProfilesEntityAssignmentsList(version: V1, customerProfileSid: string): CustomerProfilesEntityAssignmentsListInstance;

interface CustomerProfilesEntityAssignmentsListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): CustomerProfilesEntityAssignmentsContext;
  /**
   * create a CustomerProfilesEntityAssignmentsInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: CustomerProfilesEntityAssignmentsListInstanceCreateOptions, callback?: (error: Error | null, item: CustomerProfilesEntityAssignmentsInstance) => any): Promise<CustomerProfilesEntityAssignmentsInstance>;
  /**
   * Streams CustomerProfilesEntityAssignmentsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: CustomerProfilesEntityAssignmentsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams CustomerProfilesEntityAssignmentsInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: CustomerProfilesEntityAssignmentsListInstanceEachOptions, callback?: (item: CustomerProfilesEntityAssignmentsInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a customer_profiles_entity_assignments
   *
   * @param sid - The unique string that identifies the resource
   */
  get(sid: string): CustomerProfilesEntityAssignmentsContext;
  /**
   * Retrieve a single target page of CustomerProfilesEntityAssignmentsInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsPage) => any): Promise<CustomerProfilesEntityAssignmentsPage>;
  /**
   * Retrieve a single target page of CustomerProfilesEntityAssignmentsInstance
   * records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsPage) => any): Promise<CustomerProfilesEntityAssignmentsPage>;
  /**
   * Lists CustomerProfilesEntityAssignmentsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance[]) => any): Promise<CustomerProfilesEntityAssignmentsInstance[]>;
  /**
   * Lists CustomerProfilesEntityAssignmentsInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: CustomerProfilesEntityAssignmentsListInstanceOptions, callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance[]) => any): Promise<CustomerProfilesEntityAssignmentsInstance[]>;
  /**
   * Retrieve a single page of CustomerProfilesEntityAssignmentsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsPage) => any): Promise<CustomerProfilesEntityAssignmentsPage>;
  /**
   * Retrieve a single page of CustomerProfilesEntityAssignmentsInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: CustomerProfilesEntityAssignmentsListInstancePageOptions, callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsPage) => any): Promise<CustomerProfilesEntityAssignmentsPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property objectSid - The sid of an object bag
 */
interface CustomerProfilesEntityAssignmentsListInstanceCreateOptions {
  objectSid: string;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesEntityAssignmentsListInstanceEachOptions {
  callback?: (item: CustomerProfilesEntityAssignmentsInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface CustomerProfilesEntityAssignmentsListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface CustomerProfilesEntityAssignmentsListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface CustomerProfilesEntityAssignmentsPayload extends CustomerProfilesEntityAssignmentsResource, Page.TwilioResponsePayload {
}

interface CustomerProfilesEntityAssignmentsResource {
  account_sid: string;
  customer_profile_sid: string;
  date_created: Date;
  object_sid: string;
  sid: string;
  url: string;
}

interface CustomerProfilesEntityAssignmentsSolution {
  customerProfileSid?: string;
}


declare class CustomerProfilesEntityAssignmentsContext {
  /**
   * Initialize the CustomerProfilesEntityAssignmentsContext
   *
   * @param version - Version of the resource
   * @param customerProfileSid - The unique string that identifies the resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, customerProfileSid: string, sid: string);

  /**
   * fetch a CustomerProfilesEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance) => any): Promise<CustomerProfilesEntityAssignmentsInstance>;
  /**
   * remove a CustomerProfilesEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance) => any): Promise<boolean>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class CustomerProfilesEntityAssignmentsInstance extends SerializableClass {
  /**
   * Initialize the CustomerProfilesEntityAssignmentsContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param customerProfileSid - The unique string that identifies the CustomerProfile resource.
   * @param sid - The unique string that identifies the resource
   */
  constructor(version: V1, payload: CustomerProfilesEntityAssignmentsPayload, customerProfileSid: string, sid: string);

  private _proxy: CustomerProfilesEntityAssignmentsContext;
  accountSid: string;
  customerProfileSid: string;
  dateCreated: Date;
  /**
   * fetch a CustomerProfilesEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance) => any): Promise<CustomerProfilesEntityAssignmentsInstance>;
  objectSid: string;
  /**
   * remove a CustomerProfilesEntityAssignmentsInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: CustomerProfilesEntityAssignmentsInstance) => any): Promise<boolean>;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  url: string;
}


declare class CustomerProfilesEntityAssignmentsPage extends Page<V1, CustomerProfilesEntityAssignmentsPayload, CustomerProfilesEntityAssignmentsResource, CustomerProfilesEntityAssignmentsInstance> {
  /**
   * Initialize the CustomerProfilesEntityAssignmentsPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: CustomerProfilesEntityAssignmentsSolution);

  /**
   * Build an instance of CustomerProfilesEntityAssignmentsInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: CustomerProfilesEntityAssignmentsPayload): CustomerProfilesEntityAssignmentsInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { CustomerProfilesEntityAssignmentsContext, CustomerProfilesEntityAssignmentsInstance, CustomerProfilesEntityAssignmentsList, CustomerProfilesEntityAssignmentsListInstance, CustomerProfilesEntityAssignmentsListInstanceCreateOptions, CustomerProfilesEntityAssignmentsListInstanceEachOptions, CustomerProfilesEntityAssignmentsListInstanceOptions, CustomerProfilesEntityAssignmentsListInstancePageOptions, CustomerProfilesEntityAssignmentsPage, CustomerProfilesEntityAssignmentsPayload, CustomerProfilesEntityAssignmentsResource, CustomerProfilesEntityAssignmentsSolution }
