/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { SerializableClass } from '../../../interfaces';

type ParticipantConversationState = 'inactive'|'active'|'closed';

/**
 * Initialize the ParticipantConversationList
 *
 * @param version - Version of the resource
 */
declare function ParticipantConversationList(version: V1): ParticipantConversationListInstance;

interface ParticipantConversationListInstance {
  /**
   * Streams ParticipantConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ParticipantConversationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ParticipantConversationInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ParticipantConversationListInstanceEachOptions, callback?: (item: ParticipantConversationInstance, done: (err?: Error) => void) => void): void;
  /**
   * Retrieve a single target page of ParticipantConversationInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ParticipantConversationPage) => any): Promise<ParticipantConversationPage>;
  /**
   * Retrieve a single target page of ParticipantConversationInstance records from
   * the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ParticipantConversationPage) => any): Promise<ParticipantConversationPage>;
  /**
   * Lists ParticipantConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ParticipantConversationInstance[]) => any): Promise<ParticipantConversationInstance[]>;
  /**
   * Lists ParticipantConversationInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ParticipantConversationListInstanceOptions, callback?: (error: Error | null, items: ParticipantConversationInstance[]) => any): Promise<ParticipantConversationInstance[]>;
  /**
   * Retrieve a single page of ParticipantConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ParticipantConversationPage) => any): Promise<ParticipantConversationPage>;
  /**
   * Retrieve a single page of ParticipantConversationInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ParticipantConversationListInstancePageOptions, callback?: (error: Error | null, items: ParticipantConversationPage) => any): Promise<ParticipantConversationPage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to each
 *
 * @property address - A unique string identifier for the conversation participant who's not a Conversation User.
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property identity - A unique string identifier for the conversation participant as Conversation User.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ParticipantConversationListInstanceEachOptions {
  address?: string;
  callback?: (item: ParticipantConversationInstance, done: (err?: Error) => void) => void;
  done?: Function;
  identity?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property address - A unique string identifier for the conversation participant who's not a Conversation User.
 * @property identity - A unique string identifier for the conversation participant as Conversation User.
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ParticipantConversationListInstanceOptions {
  address?: string;
  identity?: string;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property address - A unique string identifier for the conversation participant who's not a Conversation User.
 * @property identity - A unique string identifier for the conversation participant as Conversation User.
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ParticipantConversationListInstancePageOptions {
  address?: string;
  identity?: string;
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ParticipantConversationPayload extends ParticipantConversationResource, Page.TwilioResponsePayload {
}

interface ParticipantConversationResource {
  account_sid: string;
  chat_service_sid: string;
  conversation_attributes: string;
  conversation_created_by: string;
  conversation_date_created: Date;
  conversation_date_updated: Date;
  conversation_friendly_name: string;
  conversation_sid: string;
  conversation_state: ParticipantConversationState;
  conversation_timers: object;
  conversation_unique_name: string;
  links: string;
  participant_identity: string;
  participant_messaging_binding: object;
  participant_sid: string;
  participant_user_sid: string;
}

interface ParticipantConversationSolution {
}


declare class ParticipantConversationInstance extends SerializableClass {
  /**
   * Initialize the ParticipantConversationContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   */
  constructor(version: V1, payload: ParticipantConversationPayload);

  accountSid: string;
  chatServiceSid: string;
  conversationAttributes: string;
  conversationCreatedBy: string;
  conversationDateCreated: Date;
  conversationDateUpdated: Date;
  conversationFriendlyName: string;
  conversationSid: string;
  conversationState: ParticipantConversationState;
  conversationTimers: any;
  conversationUniqueName: string;
  links: string;
  participantIdentity: string;
  participantMessagingBinding: any;
  participantSid: string;
  participantUserSid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class ParticipantConversationPage extends Page<V1, ParticipantConversationPayload, ParticipantConversationResource, ParticipantConversationInstance> {
  /**
   * Initialize the ParticipantConversationPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ParticipantConversationSolution);

  /**
   * Build an instance of ParticipantConversationInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ParticipantConversationPayload): ParticipantConversationInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ParticipantConversationInstance, ParticipantConversationList, ParticipantConversationListInstance, ParticipantConversationListInstanceEachOptions, ParticipantConversationListInstanceOptions, ParticipantConversationListInstancePageOptions, ParticipantConversationPage, ParticipantConversationPayload, ParticipantConversationResource, ParticipantConversationSolution, ParticipantConversationState }
