/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../base/Page');
import Response = require('../../../http/response');
import V1 = require('../V1');
import { AlphaSenderList } from './service/alphaSender';
import { AlphaSenderListInstance } from './service/alphaSender';
import { PhoneNumberList } from './service/phoneNumber';
import { PhoneNumberListInstance } from './service/phoneNumber';
import { SerializableClass } from '../../../interfaces';
import { ShortCodeList } from './service/shortCode';
import { ShortCodeListInstance } from './service/shortCode';
import { UsAppToPersonList } from './service/usAppToPerson';
import { UsAppToPersonListInstance } from './service/usAppToPerson';
import { UsAppToPersonUsecaseList } from './service/usAppToPersonUsecase';
import { UsAppToPersonUsecaseListInstance } from './service/usAppToPersonUsecase';

type ServiceScanMessageContent = 'inherit'|'enable'|'disable';

/**
 * Initialize the ServiceList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @param version - Version of the resource
 */
declare function ServiceList(version: V1): ServiceListInstance;

/**
 * Options to pass to update
 *
 * @property areaCodeGeomatch - Whether to enable Area Code Geomatch on the Service Instance
 * @property fallbackMethod - The HTTP method we should use to call fallback_url
 * @property fallbackToLongCode - Whether to enable Fallback to Long Code for messages sent through the Service instance
 * @property fallbackUrl - The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property friendlyName - A string to describe the resource
 * @property inboundMethod - The HTTP method we should use to call inbound_request_url
 * @property inboundRequestUrl - The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property mmsConverter - Whether to enable the MMS Converter for messages sent through the Service instance
 * @property scanMessageContent - Reserved
 * @property smartEncoding - Whether to enable Encoding for messages sent through the Service instance
 * @property statusCallback - The URL we should call to pass status updates about message delivery
 * @property stickySender - Whether to enable Sticky Sender on the Service instance
 * @property synchronousValidation - Reserved
 * @property useInboundWebhookOnNumber - If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
 * @property validityPeriod - How long, in seconds, messages sent from the Service are valid
 */
interface ServiceInstanceUpdateOptions {
  areaCodeGeomatch?: boolean;
  fallbackMethod?: string;
  fallbackToLongCode?: boolean;
  fallbackUrl?: string;
  friendlyName?: string;
  inboundMethod?: string;
  inboundRequestUrl?: string;
  mmsConverter?: boolean;
  scanMessageContent?: ServiceScanMessageContent;
  smartEncoding?: boolean;
  statusCallback?: string;
  stickySender?: boolean;
  synchronousValidation?: boolean;
  useInboundWebhookOnNumber?: boolean;
  validityPeriod?: number;
}

interface ServiceListInstance {
  /**
   * @param sid - sid of instance
   */
  (sid: string): ServiceContext;
  /**
   * create a ServiceInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts: ServiceListInstanceCreateOptions, callback?: (error: Error | null, item: ServiceInstance) => any): Promise<ServiceInstance>;
  /**
   * Streams ServiceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Function to process each record
   */
  each(callback?: (item: ServiceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Streams ServiceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Function to process each record
   */
  each(opts?: ServiceListInstanceEachOptions, callback?: (item: ServiceInstance, done: (err?: Error) => void) => void): void;
  /**
   * Constructs a service
   *
   * @param sid - The SID that identifies the resource to fetch
   */
  get(sid: string): ServiceContext;
  /**
   * Retrieve a single target page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  getPage(callback?: (error: Error | null, items: ServicePage) => any): Promise<ServicePage>;
  /**
   * Retrieve a single target page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param targetUrl - API-generated URL for the requested results page
   * @param callback - Callback to handle list of records
   */
  getPage(targetUrl?: string, callback?: (error: Error | null, items: ServicePage) => any): Promise<ServicePage>;
  /**
   * Lists ServiceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  list(callback?: (error: Error | null, items: ServiceInstance[]) => any): Promise<ServiceInstance[]>;
  /**
   * Lists ServiceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  list(opts?: ServiceListInstanceOptions, callback?: (error: Error | null, items: ServiceInstance[]) => any): Promise<ServiceInstance[]>;
  /**
   * Retrieve a single page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param callback - Callback to handle list of records
   */
  page(callback?: (error: Error | null, items: ServicePage) => any): Promise<ServicePage>;
  /**
   * Retrieve a single page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @param opts - Options for request
   * @param callback - Callback to handle list of records
   */
  page(opts?: ServiceListInstancePageOptions, callback?: (error: Error | null, items: ServicePage) => any): Promise<ServicePage>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property areaCodeGeomatch - Whether to enable Area Code Geomatch on the Service Instance
 * @property fallbackMethod - The HTTP method we should use to call fallback_url
 * @property fallbackToLongCode - Whether to enable Fallback to Long Code for messages sent through the Service instance
 * @property fallbackUrl - The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property friendlyName - A string to describe the resource
 * @property inboundMethod - The HTTP method we should use to call inbound_request_url
 * @property inboundRequestUrl - The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property mmsConverter - Whether to enable the MMS Converter for messages sent through the Service instance
 * @property scanMessageContent - Reserved
 * @property smartEncoding - Whether to enable Encoding for messages sent through the Service instance
 * @property statusCallback - The URL we should call to pass status updates about message delivery
 * @property stickySender - Whether to enable Sticky Sender on the Service instance
 * @property synchronousValidation - Reserved
 * @property useInboundWebhookOnNumber - If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
 * @property validityPeriod - How long, in seconds, messages sent from the Service are valid
 */
interface ServiceListInstanceCreateOptions {
  areaCodeGeomatch?: boolean;
  fallbackMethod?: string;
  fallbackToLongCode?: boolean;
  fallbackUrl?: string;
  friendlyName: string;
  inboundMethod?: string;
  inboundRequestUrl?: string;
  mmsConverter?: boolean;
  scanMessageContent?: ServiceScanMessageContent;
  smartEncoding?: boolean;
  statusCallback?: string;
  stickySender?: boolean;
  synchronousValidation?: boolean;
  useInboundWebhookOnNumber?: boolean;
  validityPeriod?: number;
}

/**
 * Options to pass to each
 *
 * @property callback -
 *                         Function to process each record. If this and a positional
 *                         callback are passed, this one will be used
 * @property done - Function to be called upon completion of streaming
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         each() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no pageSize is defined but a limit is defined,
 *                         each() will attempt to read the limit with the most efficient
 *                         page size, i.e. min(limit, 1000)
 */
interface ServiceListInstanceEachOptions {
  callback?: (item: ServiceInstance, done: (err?: Error) => void) => void;
  done?: Function;
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to list
 *
 * @property limit -
 *                         Upper limit for the number of records to return.
 *                         list() guarantees never to return more than limit.
 *                         Default is no limit
 * @property pageSize -
 *                         Number of records to fetch per request,
 *                         when not set will use the default value of 50 records.
 *                         If no page_size is defined but a limit is defined,
 *                         list() will attempt to read the limit with the most
 *                         efficient page size, i.e. min(limit, 1000)
 */
interface ServiceListInstanceOptions {
  limit?: number;
  pageSize?: number;
}

/**
 * Options to pass to page
 *
 * @property pageNumber - Page Number, this value is simply for client state
 * @property pageSize - Number of records to return, defaults to 50
 * @property pageToken - PageToken provided by the API
 */
interface ServiceListInstancePageOptions {
  pageNumber?: number;
  pageSize?: number;
  pageToken?: string;
}

interface ServicePayload extends ServiceResource, Page.TwilioResponsePayload {
}

interface ServiceResource {
  account_sid: string;
  area_code_geomatch: boolean;
  date_created: Date;
  date_updated: Date;
  fallback_method: string;
  fallback_to_long_code: boolean;
  fallback_url: string;
  friendly_name: string;
  inbound_method: string;
  inbound_request_url: string;
  links: string;
  mms_converter: boolean;
  scan_message_content: ServiceScanMessageContent;
  sid: string;
  smart_encoding: boolean;
  status_callback: string;
  sticky_sender: boolean;
  synchronous_validation: boolean;
  url: string;
  use_inbound_webhook_on_number: boolean;
  validity_period: number;
}

interface ServiceSolution {
}


declare class ServiceContext {
  /**
   * Initialize the ServiceContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, sid: string);

  alphaSenders: AlphaSenderListInstance;
  /**
   * fetch a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  phoneNumbers: PhoneNumberListInstance;
  /**
   * remove a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<boolean>;
  shortCodes: ShortCodeListInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  /**
   * update a ServiceInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ServiceInstanceUpdateOptions, callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  usAppToPerson: UsAppToPersonListInstance;
  usAppToPersonUsecases: UsAppToPersonUsecaseListInstance;
}


declare class ServiceInstance extends SerializableClass {
  /**
   * Initialize the ServiceContext
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param sid - The SID that identifies the resource to fetch
   */
  constructor(version: V1, payload: ServicePayload, sid: string);

  private _proxy: ServiceContext;
  accountSid: string;
  /**
   * Access the alphaSenders
   */
  alphaSenders(): AlphaSenderListInstance;
  areaCodeGeomatch: boolean;
  dateCreated: Date;
  dateUpdated: Date;
  fallbackMethod: string;
  fallbackToLongCode: boolean;
  fallbackUrl: string;
  /**
   * fetch a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  fetch(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  friendlyName: string;
  inboundMethod: string;
  inboundRequestUrl: string;
  links: string;
  mmsConverter: boolean;
  /**
   * Access the phoneNumbers
   */
  phoneNumbers(): PhoneNumberListInstance;
  /**
   * remove a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  remove(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<boolean>;
  scanMessageContent: ServiceScanMessageContent;
  /**
   * Access the shortCodes
   */
  shortCodes(): ShortCodeListInstance;
  sid: string;
  smartEncoding: boolean;
  statusCallback: string;
  stickySender: boolean;
  synchronousValidation: boolean;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
  /**
   * update a ServiceInstance
   *
   * @param callback - Callback to handle processed record
   */
  update(callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  /**
   * update a ServiceInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  update(opts?: ServiceInstanceUpdateOptions, callback?: (error: Error | null, items: ServiceInstance) => any): Promise<ServiceInstance>;
  url: string;
  /**
   * Access the usAppToPerson
   */
  usAppToPerson(): UsAppToPersonListInstance;
  /**
   * Access the usAppToPersonUsecases
   */
  usAppToPersonUsecases(): UsAppToPersonUsecaseListInstance;
  useInboundWebhookOnNumber: boolean;
  validityPeriod: number;
}


declare class ServicePage extends Page<V1, ServicePayload, ServiceResource, ServiceInstance> {
  /**
   * Initialize the ServicePage
   *
   * PLEASE NOTE that this class contains beta products that are subject to change.
   * Use them with caution.
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V1, response: Response<string>, solution: ServiceSolution);

  /**
   * Build an instance of ServiceInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: ServicePayload): ServiceInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { ServiceContext, ServiceInstance, ServiceInstanceUpdateOptions, ServiceList, ServiceListInstance, ServiceListInstanceCreateOptions, ServiceListInstanceEachOptions, ServiceListInstanceOptions, ServiceListInstancePageOptions, ServicePage, ServicePayload, ServiceResource, ServiceScanMessageContent, ServiceSolution }
