'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var NetworkList;
var NetworkPage;
var NetworkInstance;
var NetworkContext;

/* jshint ignore:start */
/**
 * Initialize the NetworkList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkList
 *
 * @param {Twilio.Supersim.V1} version - Version of the resource
 */
/* jshint ignore:end */
NetworkList = function NetworkList(version) {
  /* jshint ignore:start */
  /**
   * @function networks
   * @memberof Twilio.Supersim.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Supersim.V1.NetworkContext}
   */
  /* jshint ignore:end */
  function NetworkListInstance(sid) {
    return NetworkListInstance.get(sid);
  }

  NetworkListInstance._version = version;
  // Path Solution
  NetworkListInstance._solution = {};
  NetworkListInstance._uri = `/Networks`;
  /* jshint ignore:start */
  /**
   * Streams NetworkInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.isoCountry] -
   *          The ISO country code of the Network resources to read
   * @param {string} [opts.mcc] - The MCC of Network resource identifiers to be read
   * @param {string} [opts.mnc] - The MNC of Network resource identifiers to be read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  NetworkListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists NetworkInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.isoCountry] -
   *          The ISO country code of the Network resources to read
   * @param {string} [opts.mcc] - The MCC of Network resource identifiers to be read
   * @param {string} [opts.mnc] - The MNC of Network resource identifiers to be read
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of NetworkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.isoCountry] -
   *          The ISO country code of the Network resources to read
   * @param {string} [opts.mcc] - The MCC of Network resource identifiers to be read
   * @param {string} [opts.mnc] - The MNC of Network resource identifiers to be read
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'IsoCountry': _.get(opts, 'isoCountry'),
      'Mcc': _.get(opts, 'mcc'),
      'Mnc': _.get(opts, 'mnc'),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new NetworkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of NetworkInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  NetworkListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new NetworkPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a network
   *
   * @function get
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @param {string} sid - The SID of the Network resource to fetch
   *
   * @returns {Twilio.Supersim.V1.NetworkContext}
   */
  /* jshint ignore:end */
  NetworkListInstance.get = function get(sid) {
    return new NetworkContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Supersim.V1.NetworkList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  NetworkListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  NetworkListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return NetworkListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the NetworkPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {NetworkSolution} solution - Path solution
 *
 * @returns NetworkPage
 */
/* jshint ignore:end */
NetworkPage = function NetworkPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(NetworkPage.prototype, Page.prototype);
NetworkPage.prototype.constructor = NetworkPage;

/* jshint ignore:start */
/**
 * Build an instance of NetworkInstance
 *
 * @function getInstance
 * @memberof Twilio.Supersim.V1.NetworkPage#
 *
 * @param {NetworkPayload} payload - Payload response from the API
 *
 * @returns NetworkInstance
 */
/* jshint ignore:end */
NetworkPage.prototype.getInstance = function getInstance(payload) {
  return new NetworkInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NetworkPage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NetworkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} friendlyName - A human readable identifier of this resource
 * @property {string} url - The absolute URL of the Network resource
 * @property {string} isoCountry - The ISO country code of the Network resource
 * @property {object} identifiers - The MCC/MNCs included in the Network resource
 *
 * @param {V1} version - Version of the resource
 * @param {NetworkPayload} payload - The instance payload
 * @param {sid} sid - The SID of the Network resource to fetch
 */
/* jshint ignore:end */
NetworkInstance = function NetworkInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.isoCountry = payload.iso_country; // jshint ignore:line
  this.identifiers = payload.identifiers; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(NetworkInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new NetworkContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * fetch a NetworkInstance
 *
 * @function fetch
 * @memberof Twilio.Supersim.V1.NetworkInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkInstance
 */
/* jshint ignore:end */
NetworkInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

NetworkInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the NetworkContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.NetworkContext
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID of the Network resource to fetch
 */
/* jshint ignore:end */
NetworkContext = function NetworkContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Networks/${sid}`;
};

/* jshint ignore:start */
/**
 * fetch a NetworkInstance
 *
 * @function fetch
 * @memberof Twilio.Supersim.V1.NetworkContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed NetworkInstance
 */
/* jshint ignore:end */
NetworkContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new NetworkInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.NetworkContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
NetworkContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

NetworkContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  NetworkList: NetworkList,
  NetworkPage: NetworkPage,
  NetworkInstance: NetworkInstance,
  NetworkContext: NetworkContext
};
