'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var Page = require('../../../base/Page');  /* jshint ignore:line */
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var UsageRecordList;
var UsageRecordPage;
var UsageRecordInstance;

/* jshint ignore:start */
/**
 * Initialize the UsageRecordList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.UsageRecordList
 *
 * @param {Twilio.Supersim.V1} version - Version of the resource
 */
/* jshint ignore:end */
UsageRecordList = function UsageRecordList(version) {
  /* jshint ignore:start */
  /**
   * @function usageRecords
   * @memberof Twilio.Supersim.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Supersim.V1.UsageRecordContext}
   */
  /* jshint ignore:end */
  function UsageRecordListInstance(sid) {
    return UsageRecordListInstance.get(sid);
  }

  UsageRecordListInstance._version = version;
  // Path Solution
  UsageRecordListInstance._solution = {};
  UsageRecordListInstance._uri = `/UsageRecords`;
  /* jshint ignore:start */
  /**
   * Streams UsageRecordInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Supersim.V1.UsageRecordList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sim] -
   *          SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
   * @param {string} [opts.fleet] -
   *          SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
   * @param {string} [opts.network] -
   *          SID of a Network resource. Only show UsageRecords representing usage on this network.
   * @param {string} [opts.isoCountry] -
   *          Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
   * @param {usage_record.group} [opts.group] -
   *          Dimension over which to aggregate usage records.
   * @param {usage_record.granularity} [opts.granularity] -
   *          Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
   * @param {Date} [opts.startTime] -
   *          Only include usage that occurred at or after this time.
   * @param {Date} [opts.endTime] -
   *          Only include usage that occurred before this time.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  UsageRecordListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists UsageRecordInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Supersim.V1.UsageRecordList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sim] -
   *          SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
   * @param {string} [opts.fleet] -
   *          SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
   * @param {string} [opts.network] -
   *          SID of a Network resource. Only show UsageRecords representing usage on this network.
   * @param {string} [opts.isoCountry] -
   *          Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
   * @param {usage_record.group} [opts.group] -
   *          Dimension over which to aggregate usage records.
   * @param {usage_record.granularity} [opts.granularity] -
   *          Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
   * @param {Date} [opts.startTime] -
   *          Only include usage that occurred at or after this time.
   * @param {Date} [opts.endTime] -
   *          Only include usage that occurred before this time.
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsageRecordListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Supersim.V1.UsageRecordList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.sim] -
   *          SID or unique name of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
   * @param {string} [opts.fleet] -
   *          SID or unique name of a Fleet resource. Only show UsageRecords representing usage for Super SIMs belonging to this Fleet resource at the time the usage occurred.
   * @param {string} [opts.network] -
   *          SID of a Network resource. Only show UsageRecords representing usage on this network.
   * @param {string} [opts.isoCountry] -
   *          Alpha-2 ISO Country Code. Only show UsageRecords representing usage in this country.
   * @param {usage_record.group} [opts.group] -
   *          Dimension over which to aggregate usage records.
   * @param {usage_record.granularity} [opts.granularity] -
   *          Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`.
   * @param {Date} [opts.startTime] -
   *          Only include usage that occurred at or after this time.
   * @param {Date} [opts.endTime] -
   *          Only include usage that occurred before this time.
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsageRecordListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'Sim': _.get(opts, 'sim'),
      'Fleet': _.get(opts, 'fleet'),
      'Network': _.get(opts, 'network'),
      'IsoCountry': _.get(opts, 'isoCountry'),
      'Group': _.get(opts, 'group'),
      'Granularity': _.get(opts, 'granularity'),
      'StartTime': serialize.iso8601DateTime(_.get(opts, 'startTime')),
      'EndTime': serialize.iso8601DateTime(_.get(opts, 'endTime')),
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new UsageRecordPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of UsageRecordInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Supersim.V1.UsageRecordList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  UsageRecordListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new UsageRecordPage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Supersim.V1.UsageRecordList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  UsageRecordListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  UsageRecordListInstance[util.inspect.custom] = function inspect(depth, options)
      {
    return util.inspect(this.toJSON(), options);
  };

  return UsageRecordListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the UsageRecordPage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.UsageRecordPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {UsageRecordSolution} solution - Path solution
 *
 * @returns UsageRecordPage
 */
/* jshint ignore:end */
UsageRecordPage = function UsageRecordPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(UsageRecordPage.prototype, Page.prototype);
UsageRecordPage.prototype.constructor = UsageRecordPage;

/* jshint ignore:start */
/**
 * Build an instance of UsageRecordInstance
 *
 * @function getInstance
 * @memberof Twilio.Supersim.V1.UsageRecordPage#
 *
 * @param {UsageRecordPayload} payload - Payload response from the API
 *
 * @returns UsageRecordInstance
 */
/* jshint ignore:end */
UsageRecordPage.prototype.getInstance = function getInstance(payload) {
  return new UsageRecordInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.UsageRecordPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsageRecordPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsageRecordPage.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the UsageRecordContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Supersim.V1.UsageRecordInstance
 *
 * @property {string} accountSid - The SID of the Account that incurred the usage.
 * @property {string} simSid -
 *          SID of a Sim resource to which the UsageRecord belongs.
 * @property {string} networkSid -
 *          SID of the Network resource on which the usage occurred.
 * @property {string} fleetSid -
 *          SID of the Fleet resource on which the usage occurred.
 * @property {string} isoCountry -
 *          Alpha-2 ISO Country Code of the country the usage occurred in.
 * @property {object} period - The time period for which the usage is reported.
 * @property {number} dataUpload -
 *          Total data uploaded in bytes, aggregated by the query parameters.
 * @property {number} dataDownload -
 *          Total data downloaded in bytes, aggregated by the query parameters.
 * @property {number} dataTotal - Total of data_upload and data_download.
 *
 * @param {V1} version - Version of the resource
 * @param {UsageRecordPayload} payload - The instance payload
 */
/* jshint ignore:end */
UsageRecordInstance = function UsageRecordInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.simSid = payload.sim_sid; // jshint ignore:line
  this.networkSid = payload.network_sid; // jshint ignore:line
  this.fleetSid = payload.fleet_sid; // jshint ignore:line
  this.isoCountry = payload.iso_country; // jshint ignore:line
  this.period = payload.period; // jshint ignore:line
  this.dataUpload = deserialize.integer(payload.data_upload); // jshint ignore:line
  this.dataDownload = deserialize.integer(payload.data_download); // jshint ignore:line
  this.dataTotal = deserialize.integer(payload.data_total); // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Supersim.V1.UsageRecordInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
UsageRecordInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

UsageRecordInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  UsageRecordList: UsageRecordList,
  UsageRecordPage: UsageRecordPage,
  UsageRecordInstance: UsageRecordInstance
};
