/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */

import Page = require('../../../../base/Page');
import Response = require('../../../../http/response');
import V2010 = require('../../V2010');
import { SerializableClass } from '../../../../interfaces';

/**
 * Initialize the NewSigningKeyList
 *
 * @param version - Version of the resource
 * @param accountSid - A 34 character string that uniquely identifies this resource.
 */
declare function NewSigningKeyList(version: V2010, accountSid: string): NewSigningKeyListInstance;

interface NewSigningKeyListInstance {
  /**
   * create a NewSigningKeyInstance
   *
   * @param callback - Callback to handle processed record
   */
  create(callback?: (error: Error | null, item: NewSigningKeyInstance) => any): Promise<NewSigningKeyInstance>;
  /**
   * create a NewSigningKeyInstance
   *
   * @param opts - Options for request
   * @param callback - Callback to handle processed record
   */
  create(opts?: NewSigningKeyListInstanceCreateOptions, callback?: (error: Error | null, item: NewSigningKeyInstance) => any): Promise<NewSigningKeyInstance>;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

/**
 * Options to pass to create
 *
 * @property friendlyName - A string to describe the resource
 */
interface NewSigningKeyListInstanceCreateOptions {
  friendlyName?: string;
}

interface NewSigningKeyPayload extends NewSigningKeyResource, Page.TwilioResponsePayload {
}

interface NewSigningKeyResource {
  date_created: Date;
  date_updated: Date;
  friendly_name: string;
  secret: string;
  sid: string;
}

interface NewSigningKeySolution {
  accountSid?: string;
}


declare class NewSigningKeyInstance extends SerializableClass {
  /**
   * Initialize the NewSigningKeyContext
   *
   * @param version - Version of the resource
   * @param payload - The instance payload
   * @param accountSid - A 34 character string that uniquely identifies this resource.
   */
  constructor(version: V2010, payload: NewSigningKeyPayload, accountSid: string);

  dateCreated: Date;
  dateUpdated: Date;
  friendlyName: string;
  secret: string;
  sid: string;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}


declare class NewSigningKeyPage extends Page<V2010, NewSigningKeyPayload, NewSigningKeyResource, NewSigningKeyInstance> {
  /**
   * Initialize the NewSigningKeyPage
   *
   * @param version - Version of the resource
   * @param response - Response from the API
   * @param solution - Path solution
   */
  constructor(version: V2010, response: Response<string>, solution: NewSigningKeySolution);

  /**
   * Build an instance of NewSigningKeyInstance
   *
   * @param payload - Payload response from the API
   */
  getInstance(payload: NewSigningKeyPayload): NewSigningKeyInstance;
  /**
   * Provide a user-friendly representation
   */
  toJSON(): any;
}

export { NewSigningKeyInstance, NewSigningKeyList, NewSigningKeyListInstance, NewSigningKeyListInstanceCreateOptions, NewSigningKeyPage, NewSigningKeyPayload, NewSigningKeyResource, NewSigningKeySolution }
