'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var Q = require('q');  /* jshint ignore:line */
var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var AlphaSenderList = require('./service/alphaSender').AlphaSenderList;
var Page = require('../../../base/Page');  /* jshint ignore:line */
var PhoneNumberList = require('./service/phoneNumber').PhoneNumberList;
var ShortCodeList = require('./service/shortCode').ShortCodeList;
var UsAppToPersonList = require('./service/usAppToPerson').UsAppToPersonList;
var UsAppToPersonUsecaseList = require(
    './service/usAppToPersonUsecase').UsAppToPersonUsecaseList;
var deserialize = require(
    '../../../base/deserialize');  /* jshint ignore:line */
var serialize = require('../../../base/serialize');  /* jshint ignore:line */
var values = require('../../../base/values');  /* jshint ignore:line */

var ServiceList;
var ServicePage;
var ServiceInstance;
var ServiceContext;

/* jshint ignore:start */
/**
 * Initialize the ServiceList
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceList
 *
 * @param {Twilio.Messaging.V1} version - Version of the resource
 */
/* jshint ignore:end */
ServiceList = function ServiceList(version) {
  /* jshint ignore:start */
  /**
   * @function services
   * @memberof Twilio.Messaging.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Messaging.V1.ServiceContext}
   */
  /* jshint ignore:end */
  function ServiceListInstance(sid) {
    return ServiceListInstance.get(sid);
  }

  ServiceListInstance._version = version;
  // Path Solution
  ServiceListInstance._solution = {};
  ServiceListInstance._uri = `/Services`;
  /* jshint ignore:start */
  /**
   * create a ServiceInstance
   *
   * @function create
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {object} opts - Options for request
   * @param {string} opts.friendlyName - A string to describe the resource
   * @param {string} [opts.inboundRequestUrl] -
   *          The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
   * @param {string} [opts.inboundMethod] -
   *          The HTTP method we should use to call inbound_request_url
   * @param {string} [opts.fallbackUrl] -
   *          The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
   * @param {string} [opts.fallbackMethod] -
   *          The HTTP method we should use to call fallback_url
   * @param {string} [opts.statusCallback] -
   *          The URL we should call to pass status updates about message delivery
   * @param {boolean} [opts.stickySender] -
   *          Whether to enable Sticky Sender on the Service instance
   * @param {boolean} [opts.mmsConverter] -
   *          Whether to enable the MMS Converter for messages sent through the Service instance
   * @param {boolean} [opts.smartEncoding] -
   *          Whether to enable Encoding for messages sent through the Service instance
   * @param {service.scan_message_content} [opts.scanMessageContent] - Reserved
   * @param {boolean} [opts.fallbackToLongCode] -
   *          Whether to enable Fallback to Long Code for messages sent through the Service instance
   * @param {boolean} [opts.areaCodeGeomatch] -
   *          Whether to enable Area Code Geomatch on the Service Instance
   * @param {number} [opts.validityPeriod] -
   *          How long, in seconds, messages sent from the Service are valid
   * @param {boolean} [opts.synchronousValidation] - Reserved
   * @param {boolean} [opts.useInboundWebhookOnNumber] -
   *          If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
   * @param {function} [callback] - Callback to handle processed record
   *
   * @returns {Promise} Resolves to processed ServiceInstance
   */
  /* jshint ignore:end */
  ServiceListInstance.create = function create(opts, callback) {
    if (_.isUndefined(opts)) {
      throw new Error('Required parameter "opts" missing.');
    }
    if (_.isUndefined(opts.friendlyName)) {
      throw new Error('Required parameter "opts.friendlyName" missing.');
    }

    var deferred = Q.defer();
    var data = values.of({
      'FriendlyName': _.get(opts, 'friendlyName'),
      'InboundRequestUrl': _.get(opts, 'inboundRequestUrl'),
      'InboundMethod': _.get(opts, 'inboundMethod'),
      'FallbackUrl': _.get(opts, 'fallbackUrl'),
      'FallbackMethod': _.get(opts, 'fallbackMethod'),
      'StatusCallback': _.get(opts, 'statusCallback'),
      'StickySender': serialize.bool(_.get(opts, 'stickySender')),
      'MmsConverter': serialize.bool(_.get(opts, 'mmsConverter')),
      'SmartEncoding': serialize.bool(_.get(opts, 'smartEncoding')),
      'ScanMessageContent': _.get(opts, 'scanMessageContent'),
      'FallbackToLongCode': serialize.bool(_.get(opts, 'fallbackToLongCode')),
      'AreaCodeGeomatch': serialize.bool(_.get(opts, 'areaCodeGeomatch')),
      'ValidityPeriod': _.get(opts, 'validityPeriod'),
      'SynchronousValidation': serialize.bool(_.get(opts, 'synchronousValidation')),
      'UseInboundWebhookOnNumber': serialize.bool(_.get(opts, 'useInboundWebhookOnNumber'))
    });

    var promise = this._version.create({uri: this._uri, method: 'POST', data: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Streams ServiceInstance records from the API.
   *
   * This operation lazily loads records as efficiently as possible until the limit
   * is reached.
   *
   * The results are passed into the callback function, so this operation is memory
   * efficient.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function each
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         each() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no pageSize is defined but a limit is defined,
   *         each() will attempt to read the limit with the most efficient
   *         page size, i.e. min(limit, 1000)
   * @param {Function} [opts.callback] -
   *         Function to process each record. If this and a positional
   *         callback are passed, this one will be used
   * @param {Function} [opts.done] -
   *          Function to be called upon completion of streaming
   * @param {Function} [callback] - Function to process each record
   */
  /* jshint ignore:end */
  ServiceListInstance.each = function each(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    if (opts.callback) {
      callback = opts.callback;
    }
    if (_.isUndefined(callback)) {
      throw new Error('Callback function must be provided');
    }

    var done = false;
    var currentPage = 1;
    var currentResource = 0;
    var limits = this._version.readLimits({
      limit: opts.limit,
      pageSize: opts.pageSize
    });

    function onComplete(error) {
      done = true;
      if (_.isFunction(opts.done)) {
        opts.done(error);
      }
    }

    function fetchNextPage(fn) {
      var promise = fn();
      if (_.isUndefined(promise)) {
        onComplete();
        return;
      }

      promise.then(function(page) {
        _.each(page.instances, function(instance) {
          if (done || (!_.isUndefined(opts.limit) && currentResource >= opts.limit)) {
            done = true;
            return false;
          }

          currentResource++;
          callback(instance, onComplete);
        });

        if (!done) {
          currentPage++;
          fetchNextPage(_.bind(page.nextPage, page));
        }
      });

      promise.catch(onComplete);
    }

    fetchNextPage(_.bind(this.page, this, _.merge(opts, limits)));
  };

  /* jshint ignore:start */
  /**
   * Lists ServiceInstance records from the API as a list.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function list
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {number} [opts.limit] -
   *         Upper limit for the number of records to return.
   *         list() guarantees never to return more than limit.
   *         Default is no limit
   * @param {number} [opts.pageSize] -
   *         Number of records to fetch per request,
   *         when not set will use the default value of 50 records.
   *         If no page_size is defined but a limit is defined,
   *         list() will attempt to read the limit with the most
   *         efficient page size, i.e. min(limit, 1000)
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.list = function list(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};
    var deferred = Q.defer();
    var allResources = [];
    opts.callback = function(resource, done) {
      allResources.push(resource);

      if (!_.isUndefined(opts.limit) && allResources.length === opts.limit) {
        done();
      }
    };

    opts.done = function(error) {
      if (_.isUndefined(error)) {
        deferred.resolve(allResources);
      } else {
        deferred.reject(error);
      }
    };

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    this.each(opts);
    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function page
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {object} [opts] - Options for request
   * @param {string} [opts.pageToken] - PageToken provided by the API
   * @param {number} [opts.pageNumber] -
   *          Page Number, this value is simply for client state
   * @param {number} [opts.pageSize] - Number of records to return, defaults to 50
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.page = function page(opts, callback) {
    if (_.isFunction(opts)) {
      callback = opts;
      opts = {};
    }
    opts = opts || {};

    var deferred = Q.defer();
    var data = values.of({
      'PageToken': opts.pageToken,
      'Page': opts.pageNumber,
      'PageSize': opts.pageSize
    });

    var promise = this._version.page({uri: this._uri, method: 'GET', params: data});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Retrieve a single target page of ServiceInstance records from the API.
   *
   * The request is executed immediately.
   *
   * If a function is passed as the first argument, it will be used as the callback
   * function.
   *
   * @function getPage
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {string} [targetUrl] - API-generated URL for the requested results page
   * @param {function} [callback] - Callback to handle list of records
   *
   * @returns {Promise} Resolves to a list of records
   */
  /* jshint ignore:end */
  ServiceListInstance.getPage = function getPage(targetUrl, callback) {
    var deferred = Q.defer();

    var promise = this._version._domain.twilio.request({method: 'GET', uri: targetUrl});

    promise = promise.then(function(payload) {
      deferred.resolve(new ServicePage(this._version, payload, this._solution));
    }.bind(this));

    promise.catch(function(error) {
      deferred.reject(error);
    });

    if (_.isFunction(callback)) {
      deferred.promise.nodeify(callback);
    }

    return deferred.promise;
  };

  /* jshint ignore:start */
  /**
   * Constructs a service
   *
   * @function get
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @param {string} sid - The SID that identifies the resource to fetch
   *
   * @returns {Twilio.Messaging.V1.ServiceContext}
   */
  /* jshint ignore:end */
  ServiceListInstance.get = function get(sid) {
    return new ServiceContext(this._version, sid);
  };

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Messaging.V1.ServiceList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  ServiceListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  ServiceListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return ServiceListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the ServicePage
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServicePage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {ServiceSolution} solution - Path solution
 *
 * @returns ServicePage
 */
/* jshint ignore:end */
ServicePage = function ServicePage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(ServicePage.prototype, Page.prototype);
ServicePage.prototype.constructor = ServicePage;

/* jshint ignore:start */
/**
 * Build an instance of ServiceInstance
 *
 * @function getInstance
 * @memberof Twilio.Messaging.V1.ServicePage#
 *
 * @param {ServicePayload} payload - Payload response from the API
 *
 * @returns ServiceInstance
 */
/* jshint ignore:end */
ServicePage.prototype.getInstance = function getInstance(payload) {
  return new ServiceInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServicePage#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServicePage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServicePage.prototype[util.inspect.custom] = function inspect(depth, options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceInstance
 *
 * @property {string} sid - The unique string that identifies the resource
 * @property {string} accountSid - The SID of the Account that created the resource
 * @property {string} friendlyName -
 *          The string that you assigned to describe the resource
 * @property {Date} dateCreated -
 *          The ISO 8601 date and time in GMT when the resource was created
 * @property {Date} dateUpdated -
 *          The ISO 8601 date and time in GMT when the resource was last updated
 * @property {string} inboundRequestUrl -
 *          The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property {string} inboundMethod -
 *          The HTTP method we use to call inbound_request_url
 * @property {string} fallbackUrl -
 *          The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @property {string} fallbackMethod - The HTTP method we use to call fallback_url
 * @property {string} statusCallback -
 *          The URL we call to pass status updates about message delivery
 * @property {boolean} stickySender -
 *          Whether to enable Sticky Sender on the Service instance
 * @property {boolean} mmsConverter -
 *          Whether to enable the MMS Converter for messages sent through the Service instance
 * @property {boolean} smartEncoding -
 *          Whether to enable Encoding for messages sent through the Service instance
 * @property {service.scan_message_content} scanMessageContent - Reserved
 * @property {boolean} fallbackToLongCode -
 *          Whether to enable Fallback to Long Code for messages sent through the Service instance
 * @property {boolean} areaCodeGeomatch -
 *          Whether to enable Area Code Geomatch on the Service Instance
 * @property {boolean} synchronousValidation - Reserved
 * @property {number} validityPeriod -
 *          How long, in seconds, messages sent from the Service are valid
 * @property {string} url - The absolute URL of the Service resource
 * @property {string} links - The absolute URLs of related resources
 * @property {boolean} useInboundWebhookOnNumber -
 *          If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
 *
 * @param {V1} version - Version of the resource
 * @param {ServicePayload} payload - The instance payload
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
ServiceInstance = function ServiceInstance(version, payload, sid) {
  this._version = version;

  // Marshaled Properties
  this.sid = payload.sid; // jshint ignore:line
  this.accountSid = payload.account_sid; // jshint ignore:line
  this.friendlyName = payload.friendly_name; // jshint ignore:line
  this.dateCreated = deserialize.iso8601DateTime(payload.date_created); // jshint ignore:line
  this.dateUpdated = deserialize.iso8601DateTime(payload.date_updated); // jshint ignore:line
  this.inboundRequestUrl = payload.inbound_request_url; // jshint ignore:line
  this.inboundMethod = payload.inbound_method; // jshint ignore:line
  this.fallbackUrl = payload.fallback_url; // jshint ignore:line
  this.fallbackMethod = payload.fallback_method; // jshint ignore:line
  this.statusCallback = payload.status_callback; // jshint ignore:line
  this.stickySender = payload.sticky_sender; // jshint ignore:line
  this.mmsConverter = payload.mms_converter; // jshint ignore:line
  this.smartEncoding = payload.smart_encoding; // jshint ignore:line
  this.scanMessageContent = payload.scan_message_content; // jshint ignore:line
  this.fallbackToLongCode = payload.fallback_to_long_code; // jshint ignore:line
  this.areaCodeGeomatch = payload.area_code_geomatch; // jshint ignore:line
  this.synchronousValidation = payload.synchronous_validation; // jshint ignore:line
  this.validityPeriod = deserialize.integer(payload.validity_period); // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line
  this.useInboundWebhookOnNumber = payload.use_inbound_webhook_on_number; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {sid: sid || this.sid, };
};

Object.defineProperty(ServiceInstance.prototype,
  '_proxy', {
    get: function() {
      if (!this._context) {
        this._context = new ServiceContext(this._version, this._solution.sid);
      }

      return this._context;
    }
});

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {string} [opts.inboundRequestUrl] -
 *          The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @param {string} [opts.inboundMethod] -
 *          The HTTP method we should use to call inbound_request_url
 * @param {string} [opts.fallbackUrl] -
 *          The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @param {string} [opts.fallbackMethod] -
 *          The HTTP method we should use to call fallback_url
 * @param {string} [opts.statusCallback] -
 *          The URL we should call to pass status updates about message delivery
 * @param {boolean} [opts.stickySender] -
 *          Whether to enable Sticky Sender on the Service instance
 * @param {boolean} [opts.mmsConverter] -
 *          Whether to enable the MMS Converter for messages sent through the Service instance
 * @param {boolean} [opts.smartEncoding] -
 *          Whether to enable Encoding for messages sent through the Service instance
 * @param {service.scan_message_content} [opts.scanMessageContent] - Reserved
 * @param {boolean} [opts.fallbackToLongCode] -
 *          Whether to enable Fallback to Long Code for messages sent through the Service instance
 * @param {boolean} [opts.areaCodeGeomatch] -
 *          Whether to enable Area Code Geomatch on the Service Instance
 * @param {number} [opts.validityPeriod] -
 *          How long, in seconds, messages sent from the Service are valid
 * @param {boolean} [opts.synchronousValidation] - Reserved
 * @param {boolean} [opts.useInboundWebhookOnNumber] -
 *          If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.update = function update(opts, callback) {
  return this._proxy.update(opts, callback);
};

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.fetch = function fetch(callback) {
  return this._proxy.fetch(callback);
};

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceInstance.prototype.remove = function remove(callback) {
  return this._proxy.remove(callback);
};

/* jshint ignore:start */
/**
 * Access the phoneNumbers
 *
 * @function phoneNumbers
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns {Twilio.Messaging.V1.ServiceContext.PhoneNumberList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.phoneNumbers = function phoneNumbers() {
  return this._proxy.phoneNumbers;
};

/* jshint ignore:start */
/**
 * Access the shortCodes
 *
 * @function shortCodes
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns {Twilio.Messaging.V1.ServiceContext.ShortCodeList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.shortCodes = function shortCodes() {
  return this._proxy.shortCodes;
};

/* jshint ignore:start */
/**
 * Access the alphaSenders
 *
 * @function alphaSenders
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns {Twilio.Messaging.V1.ServiceContext.AlphaSenderList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.alphaSenders = function alphaSenders() {
  return this._proxy.alphaSenders;
};

/* jshint ignore:start */
/**
 * Access the usAppToPerson
 *
 * @function usAppToPerson
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns {Twilio.Messaging.V1.ServiceContext.UsAppToPersonList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.usAppToPerson = function usAppToPerson() {
  return this._proxy.usAppToPerson;
};

/* jshint ignore:start */
/**
 * Access the usAppToPersonUsecases
 *
 * @function usAppToPersonUsecases
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns {Twilio.Messaging.V1.ServiceContext.UsAppToPersonUsecaseList}
 */
/* jshint ignore:end */
ServiceInstance.prototype.usAppToPersonUsecases = function
    usAppToPersonUsecases() {
  return this._proxy.usAppToPersonUsecases;
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServiceInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

ServiceInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the ServiceContext
 *
 * PLEASE NOTE that this class contains beta products that are subject to change.
 * Use them with caution.
 *
 * @constructor Twilio.Messaging.V1.ServiceContext
 *
 * @property {Twilio.Messaging.V1.ServiceContext.PhoneNumberList} phoneNumbers -
 *          phoneNumbers resource
 * @property {Twilio.Messaging.V1.ServiceContext.ShortCodeList} shortCodes -
 *          shortCodes resource
 * @property {Twilio.Messaging.V1.ServiceContext.AlphaSenderList} alphaSenders -
 *          alphaSenders resource
 * @property {Twilio.Messaging.V1.ServiceContext.UsAppToPersonList} usAppToPerson -
 *          usAppToPerson resource
 * @property {Twilio.Messaging.V1.ServiceContext.UsAppToPersonUsecaseList} usAppToPersonUsecases -
 *          usAppToPersonUsecases resource
 *
 * @param {V1} version - Version of the resource
 * @param {sid} sid - The SID that identifies the resource to fetch
 */
/* jshint ignore:end */
ServiceContext = function ServiceContext(version, sid) {
  this._version = version;

  // Path Solution
  this._solution = {sid: sid, };
  this._uri = `/Services/${sid}`;

  // Dependents
  this._phoneNumbers = undefined;
  this._shortCodes = undefined;
  this._alphaSenders = undefined;
  this._usAppToPerson = undefined;
  this._usAppToPersonUsecases = undefined;
};

/* jshint ignore:start */
/**
 * update a ServiceInstance
 *
 * @function update
 * @memberof Twilio.Messaging.V1.ServiceContext#
 *
 * @param {object} [opts] - Options for request
 * @param {string} [opts.friendlyName] - A string to describe the resource
 * @param {string} [opts.inboundRequestUrl] -
 *          The URL we call using inbound_method when a message is received by any phone number or short code in the Service. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @param {string} [opts.inboundMethod] -
 *          The HTTP method we should use to call inbound_request_url
 * @param {string} [opts.fallbackUrl] -
 *          The URL that we call using fallback_method if an error occurs while retrieving or executing the TwiML from the Inbound Request URL. This field will be overridden if the `use_inbound_webhook_on_number` field is enabled.
 * @param {string} [opts.fallbackMethod] -
 *          The HTTP method we should use to call fallback_url
 * @param {string} [opts.statusCallback] -
 *          The URL we should call to pass status updates about message delivery
 * @param {boolean} [opts.stickySender] -
 *          Whether to enable Sticky Sender on the Service instance
 * @param {boolean} [opts.mmsConverter] -
 *          Whether to enable the MMS Converter for messages sent through the Service instance
 * @param {boolean} [opts.smartEncoding] -
 *          Whether to enable Encoding for messages sent through the Service instance
 * @param {service.scan_message_content} [opts.scanMessageContent] - Reserved
 * @param {boolean} [opts.fallbackToLongCode] -
 *          Whether to enable Fallback to Long Code for messages sent through the Service instance
 * @param {boolean} [opts.areaCodeGeomatch] -
 *          Whether to enable Area Code Geomatch on the Service Instance
 * @param {number} [opts.validityPeriod] -
 *          How long, in seconds, messages sent from the Service are valid
 * @param {boolean} [opts.synchronousValidation] - Reserved
 * @param {boolean} [opts.useInboundWebhookOnNumber] -
 *          If enabled, the webhook url configured on the phone number will be used and will override the `inbound_request_url`/`fallback_url` url called when an inbound message is received.
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.update = function update(opts, callback) {
  if (_.isFunction(opts)) {
    callback = opts;
    opts = {};
  }
  opts = opts || {};

  var deferred = Q.defer();
  var data = values.of({
    'FriendlyName': _.get(opts, 'friendlyName'),
    'InboundRequestUrl': _.get(opts, 'inboundRequestUrl'),
    'InboundMethod': _.get(opts, 'inboundMethod'),
    'FallbackUrl': _.get(opts, 'fallbackUrl'),
    'FallbackMethod': _.get(opts, 'fallbackMethod'),
    'StatusCallback': _.get(opts, 'statusCallback'),
    'StickySender': serialize.bool(_.get(opts, 'stickySender')),
    'MmsConverter': serialize.bool(_.get(opts, 'mmsConverter')),
    'SmartEncoding': serialize.bool(_.get(opts, 'smartEncoding')),
    'ScanMessageContent': _.get(opts, 'scanMessageContent'),
    'FallbackToLongCode': serialize.bool(_.get(opts, 'fallbackToLongCode')),
    'AreaCodeGeomatch': serialize.bool(_.get(opts, 'areaCodeGeomatch')),
    'ValidityPeriod': _.get(opts, 'validityPeriod'),
    'SynchronousValidation': serialize.bool(_.get(opts, 'synchronousValidation')),
    'UseInboundWebhookOnNumber': serialize.bool(_.get(opts, 'useInboundWebhookOnNumber'))
  });

  var promise = this._version.update({uri: this._uri, method: 'POST', data: data});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * fetch a ServiceInstance
 *
 * @function fetch
 * @memberof Twilio.Messaging.V1.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.fetch = function fetch(callback) {
  var deferred = Q.defer();
  var promise = this._version.fetch({uri: this._uri, method: 'GET'});

  promise = promise.then(function(payload) {
    deferred.resolve(new ServiceInstance(this._version, payload, this._solution.sid));
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

/* jshint ignore:start */
/**
 * remove a ServiceInstance
 *
 * @function remove
 * @memberof Twilio.Messaging.V1.ServiceContext#
 *
 * @param {function} [callback] - Callback to handle processed record
 *
 * @returns {Promise} Resolves to processed ServiceInstance
 */
/* jshint ignore:end */
ServiceContext.prototype.remove = function remove(callback) {
  var deferred = Q.defer();
  var promise = this._version.remove({uri: this._uri, method: 'DELETE'});

  promise = promise.then(function(payload) {
    deferred.resolve(payload);
  }.bind(this));

  promise.catch(function(error) {
    deferred.reject(error);
  });

  if (_.isFunction(callback)) {
    deferred.promise.nodeify(callback);
  }

  return deferred.promise;
};

Object.defineProperty(ServiceContext.prototype,
  'phoneNumbers', {
    get: function() {
      if (!this._phoneNumbers) {
        this._phoneNumbers = new PhoneNumberList(this._version, this._solution.sid);
      }
      return this._phoneNumbers;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'shortCodes', {
    get: function() {
      if (!this._shortCodes) {
        this._shortCodes = new ShortCodeList(this._version, this._solution.sid);
      }
      return this._shortCodes;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'alphaSenders', {
    get: function() {
      if (!this._alphaSenders) {
        this._alphaSenders = new AlphaSenderList(this._version, this._solution.sid);
      }
      return this._alphaSenders;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'usAppToPerson', {
    get: function() {
      if (!this._usAppToPerson) {
        this._usAppToPerson = new UsAppToPersonList(this._version, this._solution.sid);
      }
      return this._usAppToPerson;
    }
});

Object.defineProperty(ServiceContext.prototype,
  'usAppToPersonUsecases', {
    get: function() {
      if (!this._usAppToPersonUsecases) {
        this._usAppToPersonUsecases = new UsAppToPersonUsecaseList(this._version, this._solution.sid);
      }
      return this._usAppToPersonUsecases;
    }
});

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Messaging.V1.ServiceContext#
 *
 * @returns Object
 */
/* jshint ignore:end */
ServiceContext.prototype.toJSON = function toJSON() {
  return this._solution;
};

ServiceContext.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  ServiceList: ServiceList,
  ServicePage: ServicePage,
  ServiceInstance: ServiceInstance,
  ServiceContext: ServiceContext
};
