'use strict';

/* jshint ignore:start */
/**
 * This code was generated by
 * \ / _    _  _|   _  _
 *  | (_)\/(_)(_|\/| |(/_  v1.0.0
 *       /       /
 */
/* jshint ignore:end */

var _ = require('lodash');  /* jshint ignore:line */
var util = require('util');  /* jshint ignore:line */
var CountryList = require('./messaging/country').CountryList;
var Page = require('../../../base/Page');  /* jshint ignore:line */

var MessagingList;
var MessagingPage;
var MessagingInstance;

/* jshint ignore:start */
/**
 * Initialize the MessagingList
 *
 * @constructor Twilio.Pricing.V1.MessagingList
 *
 * @param {Twilio.Pricing.V1} version - Version of the resource
 */
/* jshint ignore:end */
MessagingList = function MessagingList(version) {
  /* jshint ignore:start */
  /**
   * @function messaging
   * @memberof Twilio.Pricing.V1#
   *
   * @param {string} sid - sid of instance
   *
   * @returns {Twilio.Pricing.V1.MessagingContext}
   */
  /* jshint ignore:end */
  function MessagingListInstance(sid) {
    return MessagingListInstance.get(sid);
  }

  MessagingListInstance._version = version;
  // Path Solution
  MessagingListInstance._solution = {};

  // Components
  MessagingListInstance._countries = undefined;

  Object.defineProperty(MessagingListInstance,
    'countries', {
      get: function countries() {
        if (!this._countries) {
          this._countries = new CountryList(this._version);
        }

        return this._countries;
      }
  });

  /* jshint ignore:start */
  /**
   * Provide a user-friendly representation
   *
   * @function toJSON
   * @memberof Twilio.Pricing.V1.MessagingList#
   *
   * @returns Object
   */
  /* jshint ignore:end */
  MessagingListInstance.toJSON = function toJSON() {
    return this._solution;
  };

  MessagingListInstance[util.inspect.custom] = function inspect(depth, options) {
    return util.inspect(this.toJSON(), options);
  };

  return MessagingListInstance;
};


/* jshint ignore:start */
/**
 * Initialize the MessagingPage
 *
 * @constructor Twilio.Pricing.V1.MessagingPage
 *
 * @param {V1} version - Version of the resource
 * @param {Response<string>} response - Response from the API
 * @param {MessagingSolution} solution - Path solution
 *
 * @returns MessagingPage
 */
/* jshint ignore:end */
MessagingPage = function MessagingPage(version, response, solution) {
  // Path Solution
  this._solution = solution;

  Page.prototype.constructor.call(this, version, response, this._solution);
};

_.extend(MessagingPage.prototype, Page.prototype);
MessagingPage.prototype.constructor = MessagingPage;

/* jshint ignore:start */
/**
 * Build an instance of MessagingInstance
 *
 * @function getInstance
 * @memberof Twilio.Pricing.V1.MessagingPage#
 *
 * @param {MessagingPayload} payload - Payload response from the API
 *
 * @returns MessagingInstance
 */
/* jshint ignore:end */
MessagingPage.prototype.getInstance = function getInstance(payload) {
  return new MessagingInstance(this._version, payload);
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Pricing.V1.MessagingPage#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessagingPage.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessagingPage.prototype[util.inspect.custom] = function inspect(depth, options)
    {
  return util.inspect(this.toJSON(), options);
};


/* jshint ignore:start */
/**
 * Initialize the MessagingContext
 *
 * @constructor Twilio.Pricing.V1.MessagingInstance
 *
 * @property {string} name - The name
 * @property {string} url - The url
 * @property {string} links - The links
 *
 * @param {V1} version - Version of the resource
 * @param {MessagingPayload} payload - The instance payload
 */
/* jshint ignore:end */
MessagingInstance = function MessagingInstance(version, payload) {
  this._version = version;

  // Marshaled Properties
  this.name = payload.name; // jshint ignore:line
  this.url = payload.url; // jshint ignore:line
  this.links = payload.links; // jshint ignore:line

  // Context
  this._context = undefined;
  this._solution = {};
};

/* jshint ignore:start */
/**
 * Provide a user-friendly representation
 *
 * @function toJSON
 * @memberof Twilio.Pricing.V1.MessagingInstance#
 *
 * @returns Object
 */
/* jshint ignore:end */
MessagingInstance.prototype.toJSON = function toJSON() {
  let clone = {};
  _.forOwn(this, function(value, key) {
    if (!_.startsWith(key, '_') && ! _.isFunction(value)) {
      clone[key] = value;
    }
  });
  return clone;
};

MessagingInstance.prototype[util.inspect.custom] = function inspect(depth,
    options) {
  return util.inspect(this.toJSON(), options);
};

module.exports = {
  MessagingList: MessagingList,
  MessagingPage: MessagingPage,
  MessagingInstance: MessagingInstance
};
